/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityMarionettaTrap
extends Entity
implements OwnableEntity,
IAnimated {
    private static final EntityDataAccessor<CompoundTag> CAUGHT_ENTITIES = SynchedEntityData.m_135353_(EntityMarionettaTrap.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final AnimatedAction[] ANIMS = new AnimatedAction[0];
    private final List<LivingEntity> caughtEntities = new ArrayList<LivingEntity>();
    private boolean dirty = true;
    private final AnimationHandler<EntityMarionettaTrap> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private int tickLeft = 100;
    private LivingEntity shooter;
    private UUID shooterUUID;
    private float damageMultiplier = 0.7f;

    public EntityMarionettaTrap(EntityType<? extends EntityMarionettaTrap> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public EntityMarionettaTrap(Level world, LivingEntity shooter) {
        this((EntityType<? extends EntityMarionettaTrap>)((EntityType)ModEntities.TRAP_CHEST.get()), world);
        this.shooter = shooter;
        this.shooterUUID = shooter.m_142081_();
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
    }

    public static double horizontalMag(Vec3 vec) {
        return vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
    }

    public void addCaughtEntity(LivingEntity entity) {
        this.caughtEntities.add(entity);
        this.dirty = true;
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CAUGHT_ENTITIES, (Object)new CompoundTag());
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == CAUGHT_ENTITIES) {
            CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(CAUGHT_ENTITIES);
            this.readCaughtEntities(tag);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19861_) {
            Vec3 motion = this.m_20184_();
            double f = Math.sqrt(EntityMarionettaTrap.horizontalMag(motion));
            this.m_146922_(this.updateRotation(this.f_19859_, (float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232)));
            this.m_146926_(this.updateRotation(this.f_19860_, (float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875)));
            boolean water = this.m_20069_();
            float friction = water ? 0.8f : 0.85f;
            this.m_20256_(motion.m_82490_((double)friction).m_82492_(0.0, (double)0.05f, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        --this.tickLeft;
        this.caughtEntities.forEach(e -> {
            if (e.m_6084_()) {
                e.m_6034_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 0.05, this.m_20189_());
                e.f_19864_ = true;
                Platform.INSTANCE.getEntityData((LivingEntity)e).ifPresent(data -> {
                    if (!data.isOrthoView()) {
                        data.setOrthoView((LivingEntity)e, true);
                    }
                });
            }
        });
        if (!this.f_19853_.f_46443_) {
            if (this.dirty) {
                this.f_19804_.m_135381_(CAUGHT_ENTITIES, (Object)this.writeCaughtEntities());
                this.dirty = false;
            }
            if (this.tickLeft <= 21 && this.tickLeft >= 9 && this.getOwner() != null && this.tickLeft % 3 == 0) {
                this.caughtEntities.forEach(e -> CombatUtils.mobAttack(this.getOwner(), (Entity)e, new CustomDamage.Builder(this, (Entity)this.getOwner()).hurtResistant(this.tickLeft == 7 ? 10 : 0), CombatUtils.getAttributeValue((Entity)this.getOwner(), Attributes.f_22281_) * (double)this.damageMultiplier));
            }
            if (this.tickLeft <= 0) {
                this.caughtEntities.forEach(e -> Platform.INSTANCE.getEntityData((LivingEntity)e).ifPresent(data -> data.setOrthoView((LivingEntity)e, false)));
                this.m_146870_();
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.damageMultiplier = compound.m_128457_("DamageMultiplier");
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_("DamageMultiplier", this.damageMultiplier);
    }

    public boolean m_5829_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public int getTickLeft() {
        return this.tickLeft;
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)prev, (float)current);
    }

    public UUID m_142504_() {
        return this.shooterUUID;
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID uuid;
        if ((this.shooter == null || this.shooter.m_146910_()) && (uuid = this.m_142504_()) != null) {
            this.shooter = (LivingEntity)EntityUtil.findFromUUID(LivingEntity.class, (Level)this.f_19853_, (UUID)uuid);
        }
        return this.shooter;
    }

    private CompoundTag writeCaughtEntities() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.caughtEntities.forEach(e -> list.add((Object)IntTag.m_128679_((int)e.m_142049_())));
        tag.m_128365_("Caught", (Tag)list);
        return tag;
    }

    private void readCaughtEntities(CompoundTag tag) {
        ListTag list = tag.m_128437_("Caught", 3);
        this.caughtEntities.clear();
        list.forEach(t -> {
            Entity e = this.f_19853_.m_6815_(((IntTag)t).m_7047_());
            if (e instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)e;
                this.caughtEntities.add(entity);
            }
        });
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

