/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityMissile
extends BaseProjectile {
    private Entity target;

    public EntityMissile(EntityType<? extends EntityMissile> type, Level world) {
        super(type, world);
    }

    public EntityMissile(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.MISSILE.get()), world, shooter);
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public int livingTickMax() {
        return 120;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.target == null || !this.target.m_6084_()) {
                List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_(16.0).m_82369_(this.m_20184_()), e -> {
                    OwnableEntity ownable;
                    if (!e.m_6087_() || !e.m_6097_()) {
                        return false;
                    }
                    if (e.equals((Object)this.m_37282_()) || e instanceof OwnableEntity && (ownable = (OwnableEntity)e).m_142480_() == this.m_37282_()) {
                        return false;
                    }
                    return this.canHit((Entity)e);
                });
                double distSq = Double.MAX_VALUE;
                Entity res = null;
                for (Entity e2 : list) {
                    if (!(e2.m_20280_((Entity)this) < distSq)) continue;
                    res = e2;
                }
                if (res != null) {
                    this.target = res;
                }
            }
            if (this.target != null) {
                Vec3 dir;
                double angle = Math.acos((dir = this.target.m_146892_().m_82546_(this.m_20182_()).m_82541_()).m_82526_(this.m_20184_()) / (dir.m_82553_() * this.m_20184_().m_82553_()));
                dir = dir.m_82490_(Math.abs(angle) > 0.18 ? 0.03 : 0.06);
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(dir));
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        LivingEntity living;
        Entity e = result.m_82443_();
        int invul_time = 10;
        if (e instanceof LivingEntity && (living = (LivingEntity)e).m_21225_() != null && living.m_21225_().m_7640_() instanceof EntityMissile) {
            invul_time = 0;
        }
        if (CombatUtils.damageWithFaintAndCrit(this.m_37282_(), e, new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().noKnockback().hurtResistant(invul_time).element(EnumElement.LIGHT).projectile(), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null)) {
            this.m_5496_(SoundEvents.f_11913_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            S2CScreenShake.sendAround((Entity)this, 20.0, 4, 2.0f);
            this.m_146870_();
            return true;
        }
        this.m_146870_();
        return false;
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.m_5496_(SoundEvents.f_11913_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
        S2CScreenShake.sendAround((Entity)this, 20.0, 4, 2.0f);
        this.m_146870_();
    }
}

