/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityPollen
extends BaseDamageCloud {
    private static final List<Vector3f> POLLEN_BASE = RayTraceUtils.rotatedVecs((Vec3)new Vec3(1.0, 0.0, 0.0), (Vec3)new Vec3(0.0, 1.0, 0.0), (float)-180.0f, (float)135.0f, (float)45.0f);
    private static final List<Vector3f> POLLEN_IND = RayTraceUtils.rotatedVecs((Vec3)new Vec3(0.04, 0.07, 0.0), (Vec3)new Vec3(0.0, 1.0, 0.0), (float)-180.0f, (float)160.0f, (float)20.0f);

    public EntityPollen(EntityType<? extends EntityPollen> type, Level world) {
        super(type, world);
    }

    public EntityPollen(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.POLLEN.get()), world, shooter);
    }

    private double radiusSqWithOffset(double offset) {
        double r = Math.max(0.0, (double)this.getRadius() + offset);
        return r * r;
    }

    public float radiusIncrease() {
        return 0.5f;
    }

    public double maxRadius() {
        return 2.0;
    }

    public int livingTickMax() {
        return 7;
    }

    public boolean canStartDamage() {
        return this.livingTicks % 2 == 1;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.livingTicks == 1) {
            this.f_19853_.m_7605_((Entity)this, (byte)64);
        }
    }

    @Override
    protected boolean canHit(LivingEntity e) {
        double offset;
        if (!super.canHit(e)) {
            return false;
        }
        double distSq = e.m_20280_((Entity)this);
        return distSq >= this.radiusSqWithOffset(-(offset = (double)e.m_20205_() * 0.5 + 0.1)) && distSq <= this.radiusSqWithOffset(offset);
    }

    protected boolean damageEntity(LivingEntity e) {
        return CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)e, new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().noKnockback().hurtResistant(5).element(EnumElement.EARTH), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    protected AABB damageBoundingBox() {
        return super.damageBoundingBox().m_82377_(0.0, 0.3, 0.0);
    }

    public void m_7822_(byte id) {
        if (id == 64) {
            for (Vector3f base : POLLEN_BASE) {
                for (Vector3f dir : POLLEN_IND) {
                    for (int i = 0; i < 3; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.SINKING_DUST.get(), 0.039215688f, 0.5411765f, 0.047058824f, 1.0f), this.m_20185_() + (double)base.m_122239_(), this.m_20186_() + 0.05, this.m_20189_() + (double)base.m_122269_(), (double)dir.m_122239_() + (double)base.m_122239_() * 0.02, (double)dir.m_122260_(), (double)dir.m_122269_() + (double)base.m_122269_() * 0.02);
                    }
                }
            }
        } else {
            super.m_7822_(id);
        }
    }
}

