/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityRockSpear
extends BaseBeam {
    private static final EntityDataAccessor<Boolean> BIG = SynchedEntityData.m_135353_(EntityRockSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityRockSpear(EntityType<? extends EntityRockSpear> type, Level world) {
        super(type, world);
    }

    public EntityRockSpear(Level world, LivingEntity shooter, boolean big) {
        super((EntityType<? extends BaseBeam>)((EntityType)ModEntities.ROCK_SPEAR.get()), world, shooter);
        this.m_6034_(this.m_20185_(), this.m_20186_() - 0.1, this.m_20189_());
        this.f_19804_.m_135381_(BIG, (Object)big);
    }

    public boolean bigRock() {
        return (Boolean)this.f_19804_.m_135370_(BIG);
    }

    public float getRange() {
        return this.bigRock() ? 6.0f : 4.0f;
    }

    public float radius() {
        return this.bigRock() ? 0.8f : 0.5f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 15;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIG, (Object)false);
    }

    public void onImpact(EntityHitResult entityHitResult) {
        CombatUtils.damageWithFaintAndCrit(this.m_142480_(), entityHitResult.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().noKnockback().element(EnumElement.EARTH).hurtResistant(5), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    public boolean canStartDamage() {
        return this.livingTicks - 1 == 5;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(BIG, (Object)compound.m_128471_("BigRock"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("BigRock", this.bigRock());
    }
}

