/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntitySlashResidue
extends BaseDamageCloud {
    private static final Vec3[] BASE = new Vec3[]{Vec3.f_82478_, new Vec3(0.5, 0.0, 0.0), new Vec3(-0.5, 0.0, 0.0)};
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(EntitySlashResidue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean oneTimeDamage;

    public EntitySlashResidue(EntityType<? extends BaseDamageCloud> type, Level world) {
        super(type, world);
    }

    public EntitySlashResidue(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.SLASH_RESIDUE.get()), world, shooter);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (SIZE.equals(key)) {
            this.m_6210_();
        }
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(Math.max(0.2f, size)));
        this.m_20090_();
        this.m_6210_();
    }

    public void setOneTime() {
        this.oneTimeDamage = true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
    }

    public int livingTickMax() {
        return 15;
    }

    public boolean canStartDamage() {
        return !this.oneTimeDamage && this.livingTicks % 3 == 1;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            double height = this.m_142469_().m_82376_();
            for (Vec3 vec3 : BASE) {
                vec3 = vec3.m_82490_((double)((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
                Vec3 rot = MathUtils.rotate((Vec3)MathUtils.NORMAL_Y, (Vec3)vec3, (float)((float)(-Math.PI) / 180 * this.m_146908_()));
                for (double d = 0.0; d < height; d += 0.2) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + rot.f_82479_, this.m_20186_() + rot.f_82480_ + d, this.m_20189_() + rot.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        return CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, new CustomDamage.Builder((Entity)this, this.m_142480_()).noKnockback().hurtResistant(2), CombatUtils.getAttributeValue(this.m_142480_(), Attributes.f_22281_) * (double)this.damageMultiplier, null);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(compound.m_128457_("Size")));
        this.oneTimeDamage = compound.m_128471_("OneTime");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Size", ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
        compound.m_128379_("OneTime", this.oneTimeDamage);
    }

    public static enum Type {
        CHIMERA,
        SKELEFANG;

    }
}

