/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySpike
extends BaseDamageCloud {
    private static final int ATTACK_DURATION = 20;
    private static final int ATTACK_TICK = 10;
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(EntitySpike.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int targetDuration;
    private int attackDelay;
    private int attackTime;
    private int clientAttackTime;
    private LivingEntity targetMob;
    private boolean attacking;
    public int clientLightLevelHeight;

    public EntitySpike(EntityType<? extends EntitySpike> entityType, Level level) {
        super(entityType, level);
    }

    public EntitySpike(Level level, LivingEntity livingEntity, int targetDuration, int attackDelay, SpikeType spikeType) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.HOMING_SPIKES.get()), level, livingEntity);
        this.targetDuration = targetDuration;
        this.attackDelay = attackDelay;
        this.f_19804_.m_135381_(TYPE, (Object)spikeType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    public void setEntityTarget(LivingEntity target) {
        this.targetMob = target;
    }

    public Vec3 m_7371_(float partialTicks) {
        return this.m_20318_(partialTicks).m_82520_(0.0, 2.1, 0.0);
    }

    public int livingTickMax() {
        return this.targetDuration + this.attackDelay + 20;
    }

    public int spikeType() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.attackDelay = compound.m_128451_("AttackDelay");
        this.targetDuration = compound.m_128451_("TargetDuration");
        this.attackTime = compound.m_128451_("AttackTime");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AttackDelay", this.attackDelay);
        compound.m_128405_("TargetDuration", this.targetDuration);
        compound.m_128405_("AttackTime", this.attackTime);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        this.m_6034_(newX, newY, newZ);
        if (this.f_19853_.f_46443_) {
            if (!this.attacking) {
                double y = this.m_20186_();
                BlockState current = this.f_19853_.m_8055_(this.m_142538_());
                if (current.m_60795_()) {
                    current = this.f_19853_.m_8055_(this.m_142538_().m_7495_());
                    if (current.m_60795_()) {
                        current = Blocks.f_50493_.m_49966_();
                    } else {
                        y = Mth.m_14107_((double)y);
                    }
                } else {
                    y = Mth.m_14165_((double)y);
                }
                for (int i = 0; i < 6; ++i) {
                    double dX = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 0.3;
                    double dY = 0.3 + this.f_19796_.nextDouble() * 0.3;
                    double dZ = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 0.3;
                    double pY = y + this.f_19796_.nextDouble() * 0.5 - 0.25;
                    this.clientLightLevelHeight = Mth.m_14107_((double)y);
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, current), this.m_20208_(2.0), pY, this.m_20262_(2.0), dX, dY, dZ);
                }
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), current.m_60827_().m_56776_(), this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.1f + 0.75f, false);
            }
        } else if (this.livingTicks < this.targetDuration) {
            if (this.targetMob == null || this.targetMob.m_21224_()) {
                this.targetMob = EntityUtils.ownedProjectileTarget(this.m_142480_(), 12);
            }
            if (this.targetMob != null) {
                Vec3 dir = this.targetMob.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.2);
                if (this.damageBoundingBox().m_82400_(-0.25).m_82381_(this.targetMob.m_142469_())) {
                    dir = Vec3.f_82478_;
                    this.livingTicks = this.targetDuration;
                }
                this.m_20256_(dir);
                this.f_19812_ = true;
            }
        } else if (++this.attackTime > this.attackDelay) {
            this.m_20256_(Vec3.f_82478_);
            if (!this.attacking) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.attacking = true;
            }
        }
    }

    public boolean canStartDamage() {
        return this.attackTime == 10;
    }

    protected AABB damageBoundingBox() {
        return new AABB(-0.6, -0.2, -0.6, 0.6, 2.2, 0.6).m_82383_(this.m_20182_());
    }

    protected boolean damageEntity(LivingEntity target) {
        CustomDamage.Builder builder = new CustomDamage.Builder((Entity)this, this.m_142480_()).element(EnumElement.EARTH).knock(CustomDamage.KnockBackType.UP).knockAmount(0.6f).magic().hurtResistant(0);
        return CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, builder, CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.attacking = true;
            this.clientAttackTime = this.livingTicks;
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.1f + 0.75f, false);
            }
        }
    }

    public float getAnimationProgress(float partialTicks) {
        if (!this.attacking) {
            return 0.0f;
        }
        int i = this.livingTicks - this.clientAttackTime;
        float lerped = Math.min(20.0f, Mth.m_14179_((float)partialTicks, (float)i, (float)(i + 1)));
        return Mth.m_14031_((float)(lerped * (float)Math.PI / 20.0f)) * 1.2f;
    }

    public static enum SpikeType {
        EARTH,
        ROOT;

    }
}

