/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.particles.DurationalParticleData;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityStatusBall
extends BaseDamageCloud {
    private static final EntityDataAccessor<Integer> TYPE_DATA = SynchedEntityData.m_135353_(EntityStatusBall.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Type type = Type.SLEEP;
    private int maxLivingTicks;

    public EntityStatusBall(EntityType<? extends EntityStatusBall> type, Level world) {
        super(type, world);
    }

    public EntityStatusBall(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.STATUS_BALL.get()), world, shooter);
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE_DATA, (Object)0);
    }

    public void setType(Type type) {
        this.type = type;
        this.f_19804_.m_135381_(TYPE_DATA, (Object)this.type.ordinal());
        this.maxLivingTicks = this.type.maxLivingTicks;
    }

    public void setLivingTicksMax(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        int id;
        super.m_7350_(key);
        if (key == TYPE_DATA && (id = ((Integer)this.f_19804_.m_135370_(TYPE_DATA)).intValue()) >= 0 && id < Type.values().length) {
            this.type = Type.values()[id];
        }
    }

    public void shootAtPos(Vec3 targetPos, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(targetPos.m_7096_() - this.m_20185_(), targetPos.m_7098_() - this.m_20186_(), targetPos.m_7094_() - this.m_20189_());
        this.shoot(dir.f_82479_, dir.f_82480_, dir.f_82481_, velocity, inaccuracy);
    }

    public void shootFromRotation(Entity shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.m_14031_((float)((pitch + pitchOffset) * ((float)Math.PI / 180)));
        float h = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, g, h, velocity, inaccuracy);
        Vec3 vec3 = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, shooter.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vector3d);
        double f = Math.sqrt(EntityProjectile.horizontalMag((Vec3)vector3d));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            switch (this.type) {
                case SLEEP: 
                case PARALYSIS: 
                case MUSHROOM_POISON: {
                    Vector3f color;
                    int i;
                    for (i = 0; i < 2; ++i) {
                        color = this.type.particleColor;
                        this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.LIGHT.get(), color.m_122239_(), color.m_122260_(), color.m_122269_(), 1.0f, 2.0f), this.m_20185_() + this.f_19796_.nextGaussian() * 0.15, this.m_20186_() + 0.35 + this.f_19796_.nextGaussian() * 0.07, this.m_20189_() + this.f_19796_.nextGaussian() * 0.15, this.f_19796_.nextGaussian() * 0.01, Math.abs(this.f_19796_.nextGaussian() * 0.03), this.f_19796_.nextGaussian() * 0.01);
                    }
                    break;
                }
                case RAFFLESIA_SLEEP: 
                case RAFFLESIA_PARALYSIS: 
                case RAFFLESIA_POISON: 
                case RAFFLESIA_ALL: {
                    Vector3f color;
                    int i;
                    for (i = 0; i < 2; ++i) {
                        color = this.type.particleColor;
                        this.f_19853_.m_7106_((ParticleOptions)new DurationalParticleData(color.m_122239_(), color.m_122260_(), color.m_122269_(), 0.8f, 2.5f, 3), this.m_20185_() + this.f_19796_.nextGaussian() * 0.15, this.m_20186_() + 0.35 + this.f_19796_.nextGaussian() * 0.07, this.m_20189_() + this.f_19796_.nextGaussian() * 0.15, 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        }
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        this.m_6034_(newX, newY, newZ);
    }

    protected boolean damageEntity(LivingEntity target) {
        CustomDamage.Builder builder = new CustomDamage.Builder((Entity)this, this.m_142480_()).noKnockback();
        this.type.damageMod.accept(builder);
        if (CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, builder, CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    protected AABB damageBoundingBox() {
        return this.m_142469_().m_82377_(0.3, 0.45, 0.3);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StatusType", this.type.ordinal());
        compound.m_128405_("MaxTicks", this.maxLivingTicks);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.type = Type.values()[compound.m_128451_("StatusType")];
        this.maxLivingTicks = compound.m_128451_("MaxTicks");
    }

    public static enum Type {
        SLEEP(b -> b.magic().element(EnumElement.EARTH).withChangedAttribute((Attribute)ModAttributes.SLEEP.get(), 100.0), new Vector3f(0.8117647f, 0.050980393f, 0.14901961f), 40),
        MUSHROOM_POISON(b -> b.magic().withChangedAttribute((Attribute)ModAttributes.POISON.get(), 50.0), new Vector3f(0.4392157f, 0.7882353f, 0.37254903f), 40),
        PARALYSIS(b -> b.magic().withChangedAttribute((Attribute)ModAttributes.PARA.get(), 50.0), new Vector3f(0.76862746f, 0.7294118f, 0.13725491f), 40),
        RAFFLESIA_SLEEP(b -> b.hurtResistant(2).magic().withChangedAttribute((Attribute)ModAttributes.SLEEP.get(), 10.0).withChangedAttribute((Attribute)ModAttributes.FATIGUE.get(), 2.0).withChangedAttribute((Attribute)ModAttributes.COLD.get(), 2.0), new Vector3f(0.8117647f, 0.050980393f, 0.14901961f), 30),
        RAFFLESIA_PARALYSIS(b -> b.hurtResistant(2).magic().withChangedAttribute((Attribute)ModAttributes.PARA.get(), 7.0).withChangedAttribute((Attribute)ModAttributes.FATIGUE.get(), 2.0).withChangedAttribute((Attribute)ModAttributes.COLD.get(), 2.0), new Vector3f(0.8f, 0.74509805f, 0.22352941f), 30),
        RAFFLESIA_POISON(b -> b.hurtResistant(2).magic().withChangedAttribute((Attribute)ModAttributes.POISON.get(), 7.0).withChangedAttribute((Attribute)ModAttributes.FATIGUE.get(), 2.0).withChangedAttribute((Attribute)ModAttributes.COLD.get(), 2.0), new Vector3f(0.72156864f, 0.21960784f, 0.81960785f), 30),
        RAFFLESIA_ALL(b -> b.hurtResistant(2).magic().withChangedAttribute((Attribute)ModAttributes.SLEEP.get(), 5.0).withChangedAttribute((Attribute)ModAttributes.PARA.get(), 5.0).withChangedAttribute((Attribute)ModAttributes.POISON.get(), 5.0), new Vector3f(0.5294118f, 0.09019608f, 0.11372549f), 30);

        public final Consumer<CustomDamage.Builder> damageMod;
        public final Vector3f particleColor;
        public final int maxLivingTicks;

        private Type(Consumer<CustomDamage.Builder> damageMod, Vector3f particleColor, int maxLivingTicks) {
            this.damageMod = damageMod;
            this.particleColor = particleColor;
            this.maxLivingTicks = maxLivingTicks;
        }
    }
}

