/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntityThrownItem
extends BaseProjectile {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(EntityThrownItem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> ROTATING = SynchedEntityData.m_135353_(EntityThrownItem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean actAsFood;

    public EntityThrownItem(EntityType<? extends EntityThrownItem> type, Level world) {
        super(type, world);
    }

    public EntityThrownItem(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.THROWN_ITEM.get()), world, shooter);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(ROTATING, (Object)false);
    }

    public int livingTickMax() {
        return 30;
    }

    public void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), itemStack -> itemStack.m_41764_(1))));
    }

    public void setActAsFood(boolean flag) {
        this.actAsFood = flag;
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void setRotating(boolean rotating) {
        this.f_19804_.m_135381_(ROTATING, (Object)rotating);
    }

    public boolean isRotating() {
        return (Boolean)this.f_19804_.m_135370_(ROTATING);
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (this.actAsFood) {
            ItemStack stack = this.getItem();
            Entity entity = result.m_82443_();
            if (entity instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)entity;
                e = this.m_37282_();
                if (e instanceof Player) {
                    Player thrower = (Player)e;
                    if (mob.onGivingItem(thrower, stack) && stack.m_41619_()) {
                        this.m_146870_();
                    }
                } else {
                    mob.applyFoodEffect(stack);
                }
            } else {
                e = result.m_82443_();
                if (e instanceof Player) {
                    Player player = (Player)e;
                    e = this.m_37282_();
                    if (!(e instanceof Player)) {
                        player.m_5584_(player.f_19853_, stack);
                        if (stack.m_41619_()) {
                            this.m_146870_();
                        }
                    } else {
                        ItemEntity entity2 = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getItem());
                        this.f_19853_.m_7967_((Entity)entity2);
                    }
                }
            }
            return true;
        }
        boolean res = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).hurtResistant(3).projectile(), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null);
        if (res) {
            this.m_146870_();
        }
        return res;
    }

    protected void onBlockHit(BlockHitResult result) {
        if (this.actAsFood) {
            ItemEntity entity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getItem());
            this.f_19853_.m_7967_((Entity)entity);
        }
        this.m_146870_();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ItemStack itemStack = this.getItem();
        if (!itemStack.m_41619_()) {
            compound.m_128365_("Item", (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        compound.m_128379_("Rotating", this.isRotating());
        compound.m_128379_("ActAsFood", this.actAsFood);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        this.setItem(itemStack);
        this.setRotating(compound.m_128471_("Rotating"));
        this.actAsFood = compound.m_128471_("ActAsFood");
    }
}

