/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityWindBlade;
import io.github.flemmli97.runecraftory.common.particles.ColoredParticleData4f;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityTornado
extends BaseDamageCloud {
    public EntityTornado(EntityType<? extends EntityTornado> type, Level world) {
        super(type, world);
    }

    public EntityTornado(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.TORNADO.get()), world, shooter);
    }

    public int livingTickMax() {
        return 80;
    }

    public boolean canStartDamage() {
        return this.livingTicks > 3;
    }

    public void shootAtEntity(Entity target, float velocity, float inaccuracy) {
        Vec3 targetPos = EntityUtil.getStraightProjectileTarget((Vec3)this.m_20182_(), (Entity)target);
        Vec3 dir = new Vec3(targetPos.m_7096_() - this.m_20185_(), targetPos.m_7098_() - this.m_20186_(), targetPos.m_7094_() - this.m_20189_());
        this.shoot(dir.f_82479_, dir.f_82480_, dir.f_82481_, velocity, inaccuracy);
    }

    public void shootFromRotation(Entity shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.m_14031_((float)((pitch + pitchOffset) * ((float)Math.PI / 180)));
        float h = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, g, h, velocity, inaccuracy);
        Vec3 vec3 = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, shooter.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vector3d);
        double f = Math.sqrt(EntityProjectile.horizontalMag((Vec3)vector3d));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void m_8119_() {
        block2: {
            block1: {
                super.m_8119_();
                if (this.f_19853_.f_46443_) break block1;
                Entity entity = this.m_142480_();
                if (!(entity instanceof LivingEntity)) break block2;
                LivingEntity living = (LivingEntity)entity;
                if (!this.f_19796_.nextBoolean()) break block2;
                EntityWindBlade wind = new EntityWindBlade(this.f_19853_, living);
                wind.m_6034_(this.m_20185_(), this.m_20187_(), this.m_20189_());
                wind.setDamageMultiplier(this.damageMultiplier);
                wind.setType(EntityWindBlade.Type.PLAIN);
                wind.m_6686_(this.f_19796_.nextDouble() - 0.5, this.f_19796_.nextDouble() * 0.3 - 0.15, this.f_19796_.nextDouble() - 0.5, 0.6f, 3.0f);
                this.f_19853_.m_7967_((Entity)wind);
                break block2;
            }
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData4f.Builder((float)(49 + this.f_19796_.nextInt(25)) / 255.0f, (float)(150 + this.f_19796_.nextInt(40)) / 255.0f, (float)(18 + this.f_19796_.nextInt(25)) / 255.0f, 1.0f).withScale(0.2f).circle(0.3f, 10.0f).expandCircle(0.03f).withOffset(this.f_19796_.nextInt(360)).withSpeed(0.23f).build((ParticleType<ColoredParticleData4f>)((ParticleType)ModParticles.TORNADO.get())), this.m_20182_().m_7096_() + this.f_19796_.nextDouble() * 0.6 - 0.3, this.m_20182_().m_7098_() - 0.1, this.m_20182_().m_7094_() + this.f_19796_.nextDouble() * 0.6 - 0.3, 0.0, 0.0, 0.0);
            }
        }
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        this.m_6034_(newX, newY, newZ);
        this.m_20256_(motion.m_82490_(0.98));
    }

    protected boolean damageEntity(LivingEntity livingEntity) {
        return CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)livingEntity, new CustomDamage.Builder((Entity)this, this.m_142480_()).element(EnumElement.WIND).magic().noKnockback().hurtResistant(10), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    protected AABB damageBoundingBox() {
        return super.damageBoundingBox().m_82377_(0.2, 0.5, 0.2);
    }
}

