/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class EntityTreasureChest
extends Entity
implements IAnimated {
    public static final int MAX_TIER = 4;
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.m_135353_(EntityTreasureChest.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final AnimatedAction OPEN = AnimatedAction.builder((double)0.32, (String)"open").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{OPEN};
    private final AnimationHandler<EntityTreasureChest> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    protected Player lastHurtByPlayer;
    private ResourceLocation chestLoot;
    private Runnable openChest;

    public EntityTreasureChest(EntityType<? extends EntityTreasureChest> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIER, (Object)0);
    }

    public void m_6075_() {
        super.m_6075_();
        this.getAnimationHandler().tick();
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        if (!this.m_146910_() && !this.f_19853_.f_46443_ && anim != null && anim.is(new AnimatedAction[]{OPEN}) && anim.done(0)) {
            if (this.openChest != null) {
                this.openChest.run();
            }
            this.m_146870_();
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        double friction = 0.98;
        if (this.f_19861_) {
            friction = this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_())).m_60734_().m_49958_() * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_(friction, 0.98, friction));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.tier() == 4 && source != DamageSource.f_19317_) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player;
            this.lastHurtByPlayer = player = (Player)entity;
        }
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
            this.dropFromLootTable(source, true);
        }
        for (int i = 0; i < 20; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.setTier(compound.m_128451_("ChestTier"));
        if (compound.m_128441_("ChestLoot")) {
            this.chestLoot = new ResourceLocation(compound.m_128461_("ChestLoot"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("ChestTier", ((Integer)this.f_19804_.m_135370_(TIER)).intValue());
        if (this.chestLoot != null) {
            compound.m_128359_("ChestLoot", this.chestLoot.toString());
        }
    }

    public void setChestLoot(ResourceLocation loot) {
        this.chestLoot = loot;
        this.setTier(4);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.getAnimationHandler().isCurrent(new AnimatedAction[]{OPEN})) {
                this.getAnimationHandler().setAnimation(OPEN);
                this.m_5496_(SoundEvents.f_11749_, 0.7f, 1.0f);
                this.openChest = () -> this.openChest(serverPlayer, serverPlayer.m_21120_(hand));
                Platform.INSTANCE.getPlayerData(player).ifPresent(data -> LevelCalc.levelSkill(serverPlayer, data, EnumSkills.SEARCHING, 20.0f));
            }
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_5829_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return SpawnEgg.fromType((EntityType)this.m_6095_()).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public void setTier(int tier) {
        this.f_19804_.m_135381_(TIER, (Object)Mth.m_14045_((int)tier, (int)0, (int)4));
    }

    public int tier() {
        return (Integer)this.f_19804_.m_135370_(TIER);
    }

    protected void openChest(ServerPlayer player, ItemStack stack) {
        ResourceLocation resourceLocation;
        if (this.chestLoot != null) {
            resourceLocation = this.chestLoot;
        } else {
            switch (this.tier()) {
                case 1: {
                    resourceLocation = LootTableResources.TIER_2_LOOT;
                    break;
                }
                case 2: {
                    resourceLocation = LootTableResources.TIER_3_LOOT;
                    break;
                }
                case 3: {
                    resourceLocation = LootTableResources.TIER_4_LOOT;
                    break;
                }
                default: {
                    resourceLocation = LootTableResources.TIER_1_LOOT;
                }
            }
        }
        ResourceLocation resourceLocation2 = resourceLocation;
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootCtxParameters.UUID_CONTEXT, (Object)player.m_142081_()).m_78972_(LootContextParams.f_81463_, (Object)stack);
        LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(resourceLocation2);
        lootTable.m_79148_(builder.m_78975_(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((EntityTreasureChest)this).m_19983_(arg_0));
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean attackedRecently) {
        ResourceLocation resourceLocation = this.m_6095_().m_20677_();
        LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(resourceLocation);
        LootContext.Builder builder = this.createLootContext(attackedRecently, damageSource);
        lootTable.m_79148_(builder.m_78975_(LootContextParamSets.f_81415_), arg_0 -> ((EntityTreasureChest)this).m_19983_(arg_0));
    }

    protected LootContext.Builder createLootContext(boolean attackedRecently, DamageSource damageSource) {
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78984_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        if (attackedRecently && this.lastHurtByPlayer != null) {
            builder = builder.m_78972_(LootContextParams.f_81456_, (Object)this.lastHurtByPlayer).m_78963_(this.lastHurtByPlayer.m_36336_());
        }
        return builder;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

