/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityWaterLaser
extends BaseBeam {
    private static final EntityDataAccessor<Float> YAW_MOTION_VAL = SynchedEntityData.m_135353_(EntityWaterLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> MAX_LIVING_TICK = SynchedEntityData.m_135353_(EntityWaterLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> YAW_OFFSET = SynchedEntityData.m_135353_(EntityWaterLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> POSITION_YAW_OFFSET = SynchedEntityData.m_135353_(EntityWaterLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RANGE = SynchedEntityData.m_135353_(EntityWaterLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final Object2IntMap<Entity> hitEntities = new Object2IntOpenHashMap();
    private float accumulatedRot;
    private UUID other;

    public EntityWaterLaser(EntityType<? extends EntityWaterLaser> type, Level level) {
        super(type, level);
    }

    public EntityWaterLaser(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)ModEntities.WATER_LASER.get()), level, shooter);
    }

    public EntityWaterLaser(Level level, LivingEntity shooter, float yawMotion) {
        super((EntityType<? extends BaseBeam>)((EntityType)ModEntities.WATER_LASER.get()), level, shooter);
        this.f_19804_.m_135381_(YAW_MOTION_VAL, (Object)Float.valueOf(yawMotion));
    }

    public void setRotationToDirWithOffset(double dirX, double dirY, double dirZ, float acc, float yawOffset) {
        super.setRotationToDir(dirX, dirY, dirZ, acc);
        this.m_146922_(this.m_146908_() + yawOffset);
    }

    public EntityWaterLaser setMaxTicks(int ticks) {
        this.f_19804_.m_135381_(MAX_LIVING_TICK, (Object)ticks);
        return this;
    }

    public void setYawOffset(float offset) {
        this.f_19804_.m_135381_(YAW_OFFSET, (Object)Float.valueOf(offset));
    }

    public void setPositionYawOffset(float offset) {
        this.f_19804_.m_135381_(POSITION_YAW_OFFSET, (Object)Float.valueOf(offset));
    }

    public void setTwinId(UUID other) {
        this.other = other;
    }

    public void setRange(float range) {
        this.f_19804_.m_135381_(RANGE, (Object)Float.valueOf(range));
    }

    public float getRange() {
        return ((Float)this.f_19804_.m_135370_(RANGE)).floatValue();
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return (Integer)this.f_19804_.m_135370_(MAX_LIVING_TICK);
    }

    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.m_142480_() != null) {
            Entity e = this.m_142480_();
            float yRot = this.m_146908_();
            float xRot = this.m_146909_();
            this.m_146926_(e.m_146909_());
            this.m_146922_(e.m_146908_() + ((Float)this.f_19804_.m_135370_(YAW_OFFSET)).floatValue());
            this.f_19860_ = e.f_19860_;
            this.f_19859_ = e.f_19859_ + ((Float)this.f_19804_.m_135370_(YAW_OFFSET)).floatValue();
            Vector3f vec = RayTraceUtils.rotatedAround((Vec3)e.m_20154_(), (Vector3f)Vector3f.f_122225_, (float)((Float)this.f_19804_.m_135370_(POSITION_YAW_OFFSET)).floatValue());
            this.m_6034_(e.m_20185_() + (double)vec.m_122239_(), e.m_20186_() + (double)e.m_20192_() - (double)0.1f + (double)vec.m_122260_(), e.m_20189_() + (double)vec.m_122269_());
            this.accumulatedRot += Math.abs(this.m_146908_() - yRot) + Math.abs(this.m_146909_() - xRot);
        }
    }

    public boolean getHitVecFromShooter() {
        return this.m_142480_() instanceof Player;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(YAW_MOTION_VAL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAX_LIVING_TICK, (Object)20);
        this.f_19804_.m_135372_(YAW_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(POSITION_YAW_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RANGE, (Object)Float.valueOf(9.0f));
    }

    public void m_8119_() {
        ServerPlayer player;
        boolean keep;
        Entity entity;
        float yRot = this.m_146908_();
        if (((Float)this.f_19804_.m_135370_(YAW_MOTION_VAL)).floatValue() != 0.0f) {
            this.m_146922_(this.m_146908_() + ((Float)this.f_19804_.m_135370_(YAW_MOTION_VAL)).floatValue());
            this.hit = null;
        }
        if (this.accumulatedRot > 15.0f) {
            this.hitEntities.clear();
            this.accumulatedRot = 0.0f;
        }
        super.m_8119_();
        if (((Float)this.f_19804_.m_135370_(YAW_MOTION_VAL)).floatValue() != 0.0f) {
            this.f_19859_ = yRot;
        }
        if ((entity = this.m_142480_()) instanceof ServerPlayer && !(keep = Platform.INSTANCE.getPlayerData((Player)(player = (ServerPlayer)entity)).map(d -> {
            AnimatedAction action = d.getWeaponHandler().getAnimation();
            return action != null && action.is(new AnimatedAction[]{PlayerModelAnimations.WATER_LASER_ONE, PlayerModelAnimations.WATER_LASER_TWO, PlayerModelAnimations.WATER_LASER_THREE});
        }).orElse(false).booleanValue()) && this.f_19797_ < this.livingTickMax() - 5) {
            this.f_19804_.m_135381_(MAX_LIVING_TICK, (Object)(this.f_19797_ + 5));
        }
    }

    public void onImpact(EntityHitResult res) {
        LivingEntity living;
        Entity e = res.m_82443_();
        int invul_time = 5;
        if (e instanceof LivingEntity && (living = (LivingEntity)e).m_21225_() != null && living.m_21225_().m_7640_() != null && living.m_21225_().m_7640_().m_142081_().equals(this.other)) {
            invul_time = 0;
        }
        CombatUtils.damageWithFaintAndCrit(this.m_142480_(), e, new CustomDamage.Builder((Entity)this, this.m_142480_()).hurtResistant(invul_time).magic().noKnockback().element(EnumElement.WATER), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
        this.hitEntities.put((Object)e, this.f_19797_);
    }

    @Override
    protected boolean check(Entity e, Predicate<AABB> intersects) {
        if (this.f_19797_ - this.hitEntities.getOrDefault((Object)e, this.f_19797_ - 20) <= 19) {
            return false;
        }
        return super.check(e, intersects);
    }

    public boolean canStartDamage() {
        return true;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(YAW_OFFSET, (Object)Float.valueOf(compound.m_128457_("YawOffset")));
        this.f_19804_.m_135381_(RANGE, (Object)Float.valueOf(compound.m_128457_("Range")));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("YawOffset", ((Float)this.f_19804_.m_135370_(YAW_OFFSET)).floatValue());
        compound.m_128350_("Float", ((Float)this.f_19804_.m_135370_(RANGE)).floatValue());
    }
}

