/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityWindBlade
extends BaseProjectile {
    private Entity target;
    private Type type = Type.HOMING;

    public EntityWindBlade(EntityType<? extends EntityWindBlade> type, Level world) {
        super(type, world);
    }

    public EntityWindBlade(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.WIND_BLADE.get()), world, shooter);
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isPiercing() {
        return this.type == Type.PIERCING;
    }

    public int livingTickMax() {
        return this.isPiercing() ? 60 : 30;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (!(this.target != null && this.target.m_6084_() || this.type != Type.HOMING)) {
                List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_(16.0).m_82369_(this.m_20184_()), e -> {
                    OwnableEntity ownable;
                    if (!e.m_6087_() || !e.m_6097_()) {
                        return false;
                    }
                    if (e.equals((Object)this.m_37282_()) || e instanceof OwnableEntity && (ownable = (OwnableEntity)e).m_142480_() == this.m_37282_()) {
                        return false;
                    }
                    return this.canHit((Entity)e);
                });
                double distSq = Double.MAX_VALUE;
                Entity res = null;
                for (Entity e2 : list) {
                    if (!(e2.m_20280_((Entity)this) < distSq)) continue;
                    res = e2;
                }
                if (res != null) {
                    this.target = res;
                }
            }
            if (this.target != null) {
                Vec3 dir = this.target.m_146892_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.1);
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(dir));
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().noKnockback().hurtResistant(this.type == Type.PLAIN ? 2 : 10).element(EnumElement.WIND).projectile(), CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            if (!this.isPiercing()) {
                this.m_146870_();
            }
            return true;
        }
        return false;
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        if (!this.isPiercing()) {
            this.m_146870_();
        } else {
            Vec3 mot = this.m_20184_();
            Vec3 newMot = switch (blockRayTraceResult.m_82434_()) {
                case Direction.DOWN, Direction.UP -> new Vec3(mot.m_7096_(), -mot.m_7098_(), mot.m_7094_());
                case Direction.WEST, Direction.EAST -> new Vec3(-mot.m_7096_(), mot.m_7098_(), mot.m_7094_());
                default -> new Vec3(mot.m_7096_(), mot.m_7098_(), -mot.m_7094_());
            };
            if (!blockRayTraceResult.m_82436_()) {
                this.m_146884_(blockRayTraceResult.m_82450_());
            }
            this.m_20256_(newMot);
            this.doBlockCollision();
        }
    }

    private void doBlockCollision() {
        Vec3 to;
        Vec3 pos = this.m_20182_();
        BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(pos, to = pos.m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.m_82425_();
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity tileentity = this.f_19853_.m_7702_(blockpos);
                if (tileentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)tileentity));
                }
            } else if (!EventCalls.INSTANCE.projectileHitCall((Projectile)this, (HitResult)raytraceresult)) {
                this.onBlockHit(raytraceresult);
            }
        }
    }

    public static enum Type {
        PLAIN,
        HOMING,
        PIERCING;

    }
}

