/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.tenshilib.common.entity.EntityBeam;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityWindGust
extends EntityBeam {
    private Vec3 pMotion;
    private Vec3 up;
    private Vec3 side;
    private Predicate<LivingEntity> pred = e -> !e.equals((Object)this.m_142480_());

    public EntityWindGust(EntityType<? extends EntityWindGust> type, Level world) {
        super(type, world);
    }

    public EntityWindGust(Level world, LivingEntity shooter) {
        super((EntityType)ModEntities.GUST.get(), world, shooter);
        if (shooter instanceof BaseMonster) {
            this.pred = e -> ((BaseMonster)shooter).hitPred.test((LivingEntity)e);
        }
    }

    public float getRange() {
        return 8.0f;
    }

    public float radius() {
        return 2.5f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 15;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            Vec3 pos = this.m_20182_();
            for (int i = 0; i < 4; ++i) {
                double upScale = this.f_19796_.nextDouble() * 2.0 - 1.0;
                double sideScale = this.f_19796_.nextDouble() * 2.0 - 1.0;
                Vec3 ppos = pos.m_82549_(this.up.m_82490_(upScale)).m_82549_(this.side.m_82490_(sideScale));
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.WIND.get(), 1.0f, 1.0f, 1.0f, 1.0f, 0.15f), ppos.m_7096_(), ppos.m_7098_(), ppos.m_7094_(), this.pMotion.m_7096_(), this.pMotion.m_7098_(), this.pMotion.m_7094_());
            }
        }
    }

    public HitResult getHitRay() {
        HitResult res = super.getHitRay();
        Vec3 dir = res.m_82450_().m_82546_(this.m_146892_()).m_82541_();
        this.up = this.m_20289_(1.0f).m_82541_().m_82490_((double)this.radius());
        this.side = new Vec3(RayTraceUtils.rotatedAround((Vec3)this.up, (Vector3f)new Vector3f(dir), (float)90.0f)).m_82541_().m_82490_((double)this.radius());
        this.pMotion = dir.m_82490_(0.5);
        return res;
    }

    protected boolean check(Entity e, Predicate<AABB> intersects) {
        LivingEntity living;
        return super.check(e, intersects) && (!(e instanceof LivingEntity) || this.pred.test(living = (LivingEntity)e));
    }

    public void onImpact(EntityHitResult entityRayTraceResult) {
        Entity e = entityRayTraceResult.m_82443_();
        if (e instanceof LivingEntity) {
            Vec3 mot = this.hit.m_82450_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.3);
            e.m_5997_(mot.m_7096_(), mot.m_7098_(), mot.m_7094_());
            e.f_19864_ = true;
        }
    }

    public boolean canStartDamage() {
        return true;
    }

    public Entity m_142480_() {
        Entity owner = super.m_142480_();
        if (owner instanceof BaseMonster) {
            this.pred = ((BaseMonster)owner).hitPred;
        }
        return owner;
    }
}

