/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.particles.BlockStateParticleData;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GroundShakeParticleSpawner
extends ProjectileSummonHelperEntity {
    private final HashSet<BlockPos> pos = new HashSet();
    private double arc;
    private double range;

    public GroundShakeParticleSpawner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public GroundShakeParticleSpawner(Level level, LivingEntity caster, double arc, double range) {
        super((EntityType)ModEntities.GROUND_SHAKE_PARTICLES.get(), level, caster);
        this.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
        this.maxLivingTicks = 8;
        this.arc = arc;
        this.range = range;
    }

    @Override
    protected void summonProjectiles() {
        Vec3 dir = new Vec3(this.targetX - this.m_20185_(), 0.0, this.targetZ - this.m_20189_()).m_82541_();
        float yRot = MathsHelper.YRotFrom(dir);
        double progress = (double)this.ticksExisted / (double)this.maxLivingTicks;
        double range = progress * this.range;
        int amount = Mth.m_14165_((double)(1.2 * this.arc * Math.ceil(range) / 90.0));
        for (int i = 0; i < amount; ++i) {
            float angle = yRot + (360.0f * ((float)i / (float)amount) - 0.5f);
            Vec3 target = MathUtils.rotate((Vec3)MathUtils.NORMAL_Y, (Vec3)dir.m_82490_(range), (float)(angle * ((float)Math.PI / 180)));
            target = this.m_20182_().m_82520_(target.f_82479_, -1.0, target.f_82481_);
            BlockPos pos = new BlockPos(target);
            if (this.pos.contains(pos)) continue;
            this.pos.add(pos);
            BlockState state = this.f_19853_.m_8055_(pos);
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockStateParticleData((ParticleType<? extends BlockStateParticleData>)((ParticleType)ModParticles.BLOCK.get()), state, this.f_19796_.nextFloat() * 360.0f, this.f_19796_.nextFloat() * 10.0f, 30), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 0.0, this.f_19796_.nextDouble() * 0.05 + 0.15, 0.0, 1.0);
        }
    }
}

