/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectileSummonHelperEntity
extends Entity
implements OwnableEntity {
    @Nullable
    private UUID ownerUUID;
    private LivingEntity caster;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected float damageMultiplier = 1.0f;
    protected int ticksExisted;
    protected int maxLivingTicks = 40;

    public ProjectileSummonHelperEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ProjectileSummonHelperEntity(EntityType<?> entityType, Level level, LivingEntity caster) {
        super(entityType, level);
        this.m_6034_(caster.m_20185_(), caster.m_20186_() + (double)caster.m_20192_() - 0.1, caster.m_20189_());
        this.caster = caster;
        this.ownerUUID = caster.m_142081_();
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticksExisted;
        if (!this.f_19853_.f_46443_) {
            if (this.getOwner() != null && this.getOwner().m_6084_()) {
                this.summonProjectiles();
            }
            if (this.ticksExisted >= this.maxLivingTicks) {
                this.m_146870_();
            }
        }
    }

    protected abstract void summonProjectiles();

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
        }
        this.caster = this.getOwner();
        this.targetX = compound.m_128459_("TargetX");
        this.targetY = compound.m_128459_("TargetY");
        this.targetZ = compound.m_128459_("TargetZ");
        this.damageMultiplier = compound.m_128457_("DamageMultiplier");
        this.ticksExisted = compound.m_128451_("TicksExisted");
        this.maxLivingTicks = compound.m_128451_("MaxLivingTicks");
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
        compound.m_128347_("TargetX", this.targetX);
        compound.m_128347_("TargetY", this.targetY);
        compound.m_128347_("TargetZ", this.targetZ);
        compound.m_128350_("DamageMultiplier", this.damageMultiplier);
        compound.m_128405_("TicksExisted", this.ticksExisted);
        compound.m_128405_("MaxLivingTicks", this.maxLivingTicks);
    }

    public Packet<?> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_142049_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Entity entity = this.f_19853_.m_6815_(packet.m_131509_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.setOwner(livingEntity);
        }
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        double dX = x - this.m_20185_();
        double dY = y - this.m_20186_();
        double dZ = z - this.m_20189_();
        this.m_146922_((float)(Mth.m_14136_((double)dZ, (double)dX) * 57.2957763671875) - 90.0f);
        this.m_146926_((float)(-(Mth.m_14136_((double)dY, (double)Math.sqrt(dX * dX + dZ * dZ)) * 57.2957763671875)));
    }

    @Nullable
    public UUID m_142504_() {
        return this.ownerUUID;
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.caster != null && !this.caster.m_146910_()) {
            return this.caster;
        }
        if (this.ownerUUID != null && this.f_19853_ instanceof ServerLevel) {
            Entity e = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID);
            if (e instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.caster = livingEntity = (LivingEntity)e;
            }
            return this.caster;
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity entity) {
        if (entity != null) {
            this.ownerUUID = entity.m_142081_();
            this.caster = entity;
        }
    }
}

