/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.EntityStatusBall;
import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesia;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RafflesiaBreathSummoner
extends ProjectileSummonHelperEntity {
    protected static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(RafflesiaBreathSummoner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EntityStatusBall.Type type = EntityStatusBall.Type.RAFFLESIA_SLEEP;
    private boolean reversed;

    public RafflesiaBreathSummoner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public RafflesiaBreathSummoner(Level level, LivingEntity caster, EntityStatusBall.Type element) {
        super((EntityType)ModEntities.RAFFLESIA_BREATH_SUMMONER.get(), level, caster);
        this.type = element;
        this.f_19804_.m_135381_(TYPE, (Object)this.type.ordinal());
        this.damageMultiplier = 0.7f;
        this.maxLivingTicks = 23;
        if (caster instanceof EntityRafflesia) {
            EntityRafflesia rafflesia = (EntityRafflesia)caster;
            this.reversed = rafflesia.mirrorAttack();
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        int i;
        super.m_7350_(key);
        if (key == TYPE && (i = ((Integer)this.f_19804_.m_135370_(TYPE)).intValue()) < EntityStatusBall.Type.values().length) {
            this.type = EntityStatusBall.Type.values()[i];
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    @Override
    protected void summonProjectiles() {
        float add = (float)this.f_19797_ * 70.0f / (float)this.maxLivingTicks - 35.0f;
        float rot = Mth.m_14177_((float)(this.m_146908_() + (this.reversed ? add : -add)));
        EntityStatusBall ball = new EntityStatusBall(this.f_19853_, this.getOwner());
        ball.setType(this.type);
        ball.setLivingTicksMax(60);
        ball.setDamageMultiplier(this.damageMultiplier);
        ball.shootFromRotation(this, this.m_146909_(), rot, 0.0f, 0.25f, 0.0f);
        Vec3 delta = ball.m_20184_().m_82541_().m_82490_((double)(this.getOwner().m_20205_() * 1.0f));
        ball.m_6034_(ball.m_20185_() + delta.m_7096_(), this.m_20186_(), ball.m_20189_() + delta.m_7094_());
        this.f_19853_.m_7967_((Entity)ball);
    }
}

