/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.EntitySpike;
import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RootSpikeSummoner
extends ProjectileSummonHelperEntity {
    public RootSpikeSummoner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public RootSpikeSummoner(Level level, LivingEntity caster) {
        super((EntityType)ModEntities.ROOT_SPIKE_SUMMONER.get(), level, caster);
        this.maxLivingTicks = 30;
    }

    @Override
    protected void summonProjectiles() {
        if (this.ticksExisted % 10 != 0 || this.getOwner() == null) {
            return;
        }
        EntitySpike spike = new EntitySpike(this.f_19853_, this.getOwner(), 0, 10, EntitySpike.SpikeType.ROOT);
        Vec3 targetPos = null;
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            target = EntityUtils.ownedProjectileTarget((Entity)mob, 14);
            if (target != null) {
                targetPos = target.m_20182_();
            }
        } else {
            Player player;
            HitResult result;
            target = this.getOwner();
            if (target instanceof Player && (result = RayTraceUtils.entityRayTrace((Entity)(player = (Player)target), (float)12.0f, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, (boolean)true, (boolean)false, e -> e instanceof LivingEntity)) != null) {
                targetPos = result.m_82450_();
            }
        }
        if (targetPos != null) {
            spike.m_146884_(targetPos);
        }
        this.f_19853_.m_7967_((Entity)spike);
    }
}

