/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityBuffamoo
extends ChargingMonster {
    public static final AnimatedAction CHARGE_ATTACK = AnimatedAction.builder((double)2.2, (String)"charge").marker("attack_start", new double[]{0.72}).marker("attack_end", new double[]{1.92}).build();
    public static final AnimatedAction STAMP = AnimatedAction.builder((double)0.48, (String)"stamp").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)STAMP, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{STAMP, CHARGE_ATTACK, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityBuffamoo>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(STAMP, e -> 1.0f), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(CHARGE_ATTACK).cooldown(e -> e.animationCooldown(CHARGE_ATTACK)).prepare(ChargeAction::new), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityBuffamoo>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(8.0, 4)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityBuffamoo> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityBuffamoo> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityBuffamoo(EntityType<? extends EntityBuffamoo> type, Level world) {
        super((EntityType<? extends ChargingMonster>)type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 1.8;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE_ATTACK);
            } else {
                this.getAnimationHandler().setAnimation(STAMP);
            }
        }
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{CHARGE_ATTACK});
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 0.7f;
    }

    public AnimationHandler<EntityBuffamoo> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE_ATTACK})) {
            source.knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f);
        } else if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{STAMP})) {
            source.withChangedAttribute((Attribute)ModAttributes.STUN.get(), 20.0);
        }
        return source;
    }

    @Override
    public void doWhileCharge() {
        if (this.f_19797_ % 3 == 0) {
            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_11834_, this.m_5720_(), 1.0f, this.m_21187_().nextFloat() * 0.2f);
        }
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Override
    public double chargingSpeed() {
        return 0.28f;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.4375, -0.125);
    }
}

