/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityChipsqueek
extends ChargingMonster {
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.44, (String)"tail_slap").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction ROLL = AnimatedAction.builder((double)0.56, (String)"roll").marker("attack_start", new double[]{0.2}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, ROLL, MELEE, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityChipsqueek>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 1.0f), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(ROLL).cooldown(e -> e.animationCooldown(ROLL)).prepare(ChargeAction::new), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityChipsqueek>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(8.0, 4)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityChipsqueek> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityChipsqueek> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityChipsqueek(EntityType<? extends EntityChipsqueek> type, Level world) {
        super((EntityType<? extends ChargingMonster>)type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.ENTITY_CHIPSQUEEK_HURT.get();
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{ROLL});
    }

    @Override
    public double chargingSpeed() {
        return 0.45f;
    }

    public AnimationHandler<EntityChipsqueek> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 2.3;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(ROLL);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.59375, -0.3125);
    }
}

