/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityDemon
extends BaseMonster
implements HealingPredicateEntity,
ElementalAttackMob {
    public static final AnimatedAction DARK = AnimatedAction.builder((double)0.88, (String)"cast").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction HEAL = AnimatedAction.copyOf((AnimatedAction)DARK, (String)"heal");
    public static final AnimatedAction STAB = AnimatedAction.builder((double)0.68, (String)"stab").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction STAB_LONG = AnimatedAction.builder((double)0.8, (String)"stab_long").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction SWIPE = AnimatedAction.builder((double)0.88, (String)"swipe").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)DARK, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DARK, HEAL, STAB, STAB_LONG, SWIPE, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityDemon>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(STAB, e -> 1.0f), (int)3), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(STAB_LONG, e -> 1.0f), (int)3), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SWIPE, e -> 1.0f), (int)3), WeightedEntry.m_146290_((Object)new GoalAttackAction(DARK).cooldown(e -> e.animationCooldown(DARK)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)2), WeightedEntry.m_146290_((Object)new GoalAttackAction(HEAL).cooldown(e -> e.animationCooldown(HEAL)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityDemon>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1));
    public final AnimatedAttackGoal<EntityDemon> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityDemon> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final Predicate<LivingEntity> healingPredicate = e -> {
        if (this.m_142504_() == null) {
            OwnableEntity ownable;
            if (e instanceof OwnableEntity && (ownable = (OwnableEntity)e).m_142504_() != null) {
                return false;
            }
            return e instanceof Enemy && e != this.m_5448_();
        }
        if (e instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)e;
            if (this.m_142504_().equals(ownable.m_142504_())) {
                return true;
            }
        }
        return this.m_142504_().equals(e.m_142081_());
    };

    public EntityDemon(EntityType<? extends EntityDemon> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DARK})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DARK_BALL.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{HEAL})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.CURE_ALL.get())).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.DARK_BALL.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(DARK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SWIPE);
            } else {
                this.getAnimationHandler().setAnimation(STAB);
            }
        }
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width;
        double length = width = (double)(this.m_20205_() * 1.0f);
        if (anim.is(new AnimatedAction[]{STAB})) {
            width = (double)this.m_20205_() * 1.4;
            length = (double)this.m_20205_() * 2.6;
        } else if (anim.is(new AnimatedAction[]{STAB_LONG})) {
            width = (double)this.m_20205_() * 1.4;
            length = (double)this.m_20205_() * 3.2;
        } else if (anim.is(new AnimatedAction[]{SWIPE})) {
            width = (double)this.m_20205_() * 2.75;
            length = (double)this.m_20205_() * 2.3;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    public AnimationHandler<EntityDemon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<LivingEntity> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.96875, -0.3125);
    }

    @Override
    public EnumElement getAttackElement() {
        return EnumElement.DARK;
    }
}

