/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityDuck
extends ChargingMonster {
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.72, (String)"slap").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction DIVE = AnimatedAction.builder((double)1.84, (String)"dive").marker("dive", new double[]{1.08}).infinite().build();
    private static final AnimatedAction LAND = new AnimatedAction(0.48, "land");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, DIVE, LAND, INTERACT, STILL};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityDuck>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 1.0f), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(DIVE).cooldown(e -> e.animationCooldown(DIVE)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 6.0))), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityDuck>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)3));
    public final AnimatedAttackGoal<EntityDuck> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityDuck> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityDuck(EntityType<? extends EntityDuck> type, Level world) {
        super((EntityType<? extends ChargingMonster>)type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
    }

    public AnimationHandler<? extends EntityDuck> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DIVE})) {
            if (anim.isPast("dive")) {
                if (this.getChargeMotion() == null) {
                    this.setChargeMotion(this.getChargeTo(anim));
                }
                this.m_20334_(this.getChargeMotion().f_82479_, -0.25, this.getChargeMotion().f_82481_);
                if (!this.m_20096_()) {
                    if (this.hitEntity == null) {
                        this.hitEntity = new ArrayList();
                    }
                    this.mobAttack(anim, null, e -> {
                        if (!this.hitEntity.contains(e)) {
                            this.hitEntity.add(e);
                            this.m_7327_((Entity)e);
                        }
                    });
                } else {
                    this.getAnimationHandler().setAnimation(LAND);
                    this.setChargeMotion(null);
                }
            } else {
                Vec3 delta = this.m_20184_();
                this.m_20334_(delta.f_82479_, 0.1f, delta.f_82481_);
                if (this.m_5448_() != null) {
                    this.m_21391_((Entity)this.m_5448_(), 20.0f, 30.0f);
                }
            }
        } else if (!anim.is(new AnimatedAction[]{LAND})) {
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean fixedYaw() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        return anim != null && (anim.is(new AnimatedAction[]{DIVE}) ? anim.isPast("dive") : anim.is(new AnimatedAction[]{LAND}));
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{DIVE, LAND});
    }

    @Override
    public Vec3 getChargeTo(AnimatedAction anim) {
        return EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.7);
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.8;
        double length = (double)this.m_20205_() * 2.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(DIVE);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.5375, -0.375);
    }
}

