/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityFairy
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimatedAction LIGHT = AnimatedAction.builder((double)0.72, (String)"light").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction WIND = AnimatedAction.builder((double)0.72, (String)"wind").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction HEAL = AnimatedAction.copyOf((AnimatedAction)LIGHT, (String)"heal");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)LIGHT, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{LIGHT, WIND, HEAL, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityFairy>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(WIND, 9.0, 2.0, 1.0, e -> 1.0f), (int)8), WeightedEntry.m_146290_((Object)new GoalAttackAction(LIGHT).cooldown(e -> e.animationCooldown(LIGHT)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)3), WeightedEntry.m_146290_((Object)new GoalAttackAction(HEAL).cooldown(e -> e.animationCooldown(HEAL)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityFairy>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityFairy> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityFairy> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final Predicate<LivingEntity> healingPredicate = e -> {
        if (this.m_142504_() == null) {
            OwnableEntity ownable;
            if (e instanceof OwnableEntity && (ownable = (OwnableEntity)e).m_142504_() != null) {
                return false;
            }
            return e instanceof Enemy && e != this.m_5448_();
        }
        if (e instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)e;
            if (this.m_142504_().equals(ownable.m_142504_())) {
                return true;
            }
        }
        return this.m_142504_().equals(e.m_142081_());
    };

    public EntityFairy(EntityType<? extends EntityFairy> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
        this.m_20242_(true);
        this.f_21342_ = new FreeMoveControl((Mob)this);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        this.m_21051_(Attributes.f_22280_).m_22100_(0.3);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<Player>((Mob)this, Player.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetHorizontal<Mob>((Mob)this, Mob.class, 5, true, true, this.targetPred);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{LIGHT})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.SHINE.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{WIND})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DOUBLE_SONIC.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{HEAL})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.CURE_ALL.get())).use((LivingEntity)this);
            }
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 1 ? (Spell)((Object)ModSpells.SHINE.get()) : (Spell)((Object)ModSpells.DOUBLE_BULLET.get()))) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LIGHT);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_FAIRY_AMBIENT.get();
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.m_21187_().nextInt(20) + 30 + diffAdd;
        }
        return this.m_21187_().nextInt(40) + 22 + diffAdd;
    }

    public AnimationHandler<EntityFairy> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<LivingEntity> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.625, -0.375);
    }
}

