/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityFlowerLily
extends BaseMonster {
    public static final AnimatedAction LEAP = AnimatedAction.builder((double)0.88, (String)"leap").marker("leap", new double[]{0.28}).build();
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)0.56, (String)"attack").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)ATTACK, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{LEAP, ATTACK, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityFlowerLily>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(ATTACK, 9.0, 2.0, 1.0, e -> 1.0f), (int)2), WeightedEntry.m_146290_((Object)MonsterActionUtils.simpleMeleeAction(LEAP, e -> 1.0f).withCondition((goal, target, previous) -> goal.distanceToTargetSq < 4.0), (int)5));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityFlowerLily>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(16.0f, 1.0f)), (int)1));
    public final AnimatedAttackGoal<EntityFlowerLily> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityFlowerLily> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityFlowerLily(EntityType<? extends EntityFlowerLily> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{LEAP})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double attackSize = (double)this.m_20205_() * 2.1;
        return new AABB(-attackSize, -0.2, -attackSize, attackSize, (double)this.m_20206_() + 0.2, attackSize);
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
            if (this.m_20184_().m_82556_() > 0.01) {
                return this.m_20184_();
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{LEAP})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("leap")) {
                Vec3 vec32 = EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).m_82490_(-1.8);
                this.m_20334_(vec32.f_82479_, 0.15, vec32.f_82481_);
            }
        } else if (anim.is(new AnimatedAction[]{ATTACK})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                this.rangedAttackSpell().use((LivingEntity)this);
            }
        }
    }

    protected Spell rangedAttackSpell() {
        return (Spell)((Object)ModSpells.DOUBLE_BULLET.get());
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 0 ? this.rangedAttackSpell() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)ModSounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.m_21187_().nextInt(20) + 30 + diffAdd;
        }
        return this.m_21187_().nextInt(40) + 25 + diffAdd;
    }

    public AnimationHandler<EntityFlowerLily> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.875, -0.25);
    }
}

