/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetNoLoS;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.NoClipFlyEvaluator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityGhost
extends ChargingMonster {
    public static final AnimatedAction DARKBALL = AnimatedAction.builder((double)0.64, (String)"darkball").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.2, (String)"charge").marker("attack_start", new double[]{0.36}).build();
    public static final AnimatedAction SWING = AnimatedAction.builder((double)0.52, (String)"swing").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction VANISH = AnimatedAction.builder((double)5.0, (String)"vanish").marker("teleport", new double[]{2.5}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWING, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DARKBALL, CHARGE, SWING, VANISH, INTERACT, STILL};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityGhost>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(DARKBALL, 9.0, 1.0, 1.0, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SWING, e -> 1.0f), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE)).withCondition(MonsterActionUtils.chargeCondition()).prepare(ChargeAction::new), (int)2), WeightedEntry.m_146290_((Object)new GoalAttackAction(VANISH).withCondition((goal, target, previous) -> ((EntityGhost)goal.attacker).shouldVanishNext(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityGhost>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityGhost> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGhost> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private boolean vanishNext;

    public EntityGhost(EntityType<? extends EntityGhost> type, Level world) {
        super((EntityType<? extends ChargingMonster>)type, world);
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new AirWanderGoal(this);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
        this.f_21345_.m_25363_((Goal)this.swimGoal);
        this.f_21345_.m_25352_(2, this.attack);
        this.m_20242_(true);
        this.f_19794_ = true;
        this.f_21342_ = new FreeMoveControl((Mob)this);
    }

    @Override
    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimatedAction)anim);
            if (anim != null && anim.is(new AnimatedAction[]{VANISH})) {
                this.vanishNext = (double)this.m_21187_().nextFloat() < 0.6;
            }
        };
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level){

            @Override
            protected PathFinder m_5532_(int maxDist) {
                this.f_26508_ = new NoClipFlyEvaluator();
                return new PathFinder(this.f_26508_, maxDist);
            }
        };
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        this.m_21051_(Attributes.f_22280_).m_22100_(0.31);
        this.m_21051_(Attributes.f_22278_).m_22100_(1.0);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetNoLoS<Player>((Mob)this, Player.class, 5, false, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetNoLoS<Mob>((Mob)this, Mob.class, 5, false, this.targetPred);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{VANISH})) {
            return false;
        }
        boolean ret = super.m_6469_(source, amount);
        if (ret) {
            this.vanishNext = (double)this.m_21187_().nextFloat() < 0.4;
        }
        return ret;
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            source.knock(CustomDamage.KnockBackType.BACK).knockAmount(1.0f);
        }
        return source;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 2.9;
        double length = (double)this.m_20205_() * 2.5;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.DARK_BALL.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(DARKBALL);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_GHOST_AMBIENT.get();
    }

    public AnimationHandler<EntityGhost> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean handleChargeMovement(AnimatedAction anim) {
        if (this.getChargeMotion() != null) {
            this.m_20334_(this.getChargeMotion().f_82479_ * (double)0.98f, this.m_20184_().f_82480_, this.getChargeMotion().f_82481_ * (double)0.98f);
            return true;
        }
        return false;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DARKBALL})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DARK_BALL.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{VANISH})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("teleport")) {
                LivingEntity target = this.m_5448_();
                if (target == null) {
                    double rX = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 16.0;
                    double rY = this.m_20186_() + (this.f_19796_.nextDouble() - 0.5) * 4.0;
                    double rZ = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 16.0;
                    this.teleport(rX, rY, rZ);
                } else {
                    this.teleportTowards((Entity)target);
                }
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{CHARGE});
    }

    @Override
    public void m_7023_(Vec3 vec) {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.f_19794_ = entity2.f_19794_;
        } else {
            boolean bl = this.f_19794_ = !this.playDeath();
            if (this.m_20186_() < (double)(this.f_19853_.m_141937_() + 1)) {
                vec = new Vec3(vec.f_82479_, 0.006, vec.f_82481_);
            }
        }
        this.handleFreeTravel(vec);
    }

    @Override
    public Vec3 getChargeTo(AnimatedAction anim) {
        return EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET).m_82490_(this.chargingSpeed());
    }

    private void teleportTowards(Entity entity) {
        Vec3 look = new Vec3(entity.m_20154_().f_82479_, 0.0, entity.m_20154_().f_82481_).m_82541_().m_82490_(-1.5);
        Vec3 behindEntity = entity.m_20182_().m_82549_(look);
        Vec3 dir = new Vec3(behindEntity.f_82479_ - this.m_20185_(), behindEntity.f_82480_ - this.m_20186_(), behindEntity.f_82481_ - this.m_20189_());
        if (dir.m_82556_() < 100.0) {
            this.teleport(behindEntity.f_82479_, behindEntity.f_82480_, behindEntity.f_82481_);
        } else {
            dir = dir.m_82541_();
            double e = this.m_20185_() + this.f_19796_.nextDouble() * 9.0 * dir.f_82479_;
            double g = this.m_20189_() + this.f_19796_.nextDouble() * 9.0 * dir.f_82481_;
            this.teleport(e, entity.m_20186_(), g);
        }
    }

    private void teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)mutableBlockPos).m_60767_().m_76334_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.f_19853_.m_8055_((BlockPos)mutableBlockPos);
        if (!blockState.m_60767_().m_76334_()) {
            y = this.m_20186_();
        }
        this.m_6021_(x, y + 1.0, z);
    }

    public boolean shouldVanishNext(String prev) {
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_20280_((Entity)this) > 140.0) {
            return true;
        }
        return this.f_19796_.nextFloat() < 0.2f || !prev.equals(VANISH.getID()) && this.vanishNext;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.71875, -0.625);
    }
}

