/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMobArrow;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityGoblin;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityGoblinArcher
extends EntityGoblin {
    private static final AnimatedAction BOW = AnimatedAction.builder((double)0.8, (String)"bow").marker("attack", new double[]{0.52}).build();
    private static final AnimatedAction TRIPLE = AnimatedAction.copyOf((AnimatedAction)BOW, (String)"triple");
    private static final AnimatedAction KICK = AnimatedAction.builder((double)0.56, (String)"kick").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)KICK, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{BOW, TRIPLE, KICK, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityGoblinArcher>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(KICK, e -> 0.6f), (int)1), WeightedEntry.m_146290_((Object)MonsterActionUtils.simpleRangedStrafingAction(BOW, 8.0f, 1.0f, e -> 1.0f).withCondition(ActionUtils.chanced(e -> 1.0f, (goal, target, previous) -> ((EntityGoblinArcher)goal.attacker).m_21205_().m_41720_() instanceof BowItem)), (int)6), WeightedEntry.m_146290_((Object)MonsterActionUtils.simpleRangedStrafingAction(TRIPLE, 8.0f, 1.0f, e -> 1.0f).withCondition(ActionUtils.chanced(e -> 1.0f, (goal, target, previous) -> ((EntityGoblinArcher)goal.attacker).m_21205_().m_41720_() instanceof BowItem)), (int)3));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityGoblinArcher>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)1), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityGoblinArcher> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGoblinArcher> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityGoblinArcher(EntityType<? extends EntityGoblin> type, Level level) {
        super(type, level);
        this.f_21345_.m_25363_(((EntityGoblin)this).attack);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.TRIPLE_ARROW.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(TRIPLE);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(BOW);
            } else {
                this.getAnimationHandler().setAnimation(KICK);
            }
        }
    }

    public AnimationHandler<EntityGoblinArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.3;
        double length = (double)this.m_20205_() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BOW, TRIPLE})) {
            this.m_6672_(InteractionHand.MAIN_HAND);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BOW, TRIPLE})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                boolean withTarget;
                boolean bl = withTarget = this.m_5448_() != null && this.m_21574_().m_148306_((Entity)this.m_5448_());
                if (anim.is(new AnimatedAction[]{BOW})) {
                    if (withTarget) {
                        this.shootArrow(this.m_5448_());
                    } else {
                        this.shootArrowFromRotation((LivingEntity)this);
                    }
                } else if (withTarget) {
                    this.shootTripleArrow(this.m_5448_());
                } else {
                    this.shootTripleArrowFromRotation((LivingEntity)this);
                }
                this.m_5810_();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    private void shootArrow(LivingEntity target) {
        EntityMobArrow arrow = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
        Vec3 dir = new Vec3(target.m_20185_() - arrow.m_20185_(), target.m_20227_(0.33) - arrow.m_20186_(), target.m_20189_() - arrow.m_20189_());
        double l = Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_);
        dir = dir.m_82520_(0.0, l * 0.2, 0.0);
        arrow.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)arrow);
    }

    private void shootArrowFromRotation(LivingEntity shooter) {
        EntityMobArrow arrow = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
        arrow.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)arrow);
    }

    private void shootTripleArrow(LivingEntity target) {
        EntityMobArrow arrow = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
        Vec3 dir = new Vec3(target.m_20185_() - arrow.m_20185_(), target.m_20227_(0.33) - arrow.m_20186_(), target.m_20189_() - arrow.m_20189_());
        double l = Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_);
        dir = dir.m_82520_(0.0, l * 0.2, 0.0);
        arrow.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
        this.f_19853_.m_7967_((Entity)arrow);
        Vec3 up = this.m_20289_(1.0f);
        for (float y = -15.0f; y <= 15.0f; y += 30.0f) {
            Quaternion quaternion = new Quaternion(new Vector3f(up), y, true);
            Vector3f newDir = new Vector3f(dir);
            newDir.m_122251_(quaternion);
            EntityMobArrow arrowO = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
            arrowO.m_6686_(newDir.m_122239_(), newDir.m_122260_(), newDir.m_122269_(), 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
            this.f_19853_.m_7967_((Entity)arrowO);
        }
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
    }

    private void shootTripleArrowFromRotation(LivingEntity shooter) {
        for (int i = 0; i < 3; ++i) {
            EntityMobArrow arrow = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
            arrow.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_() + (float)((i - 1) * 15), 0.0f, 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)arrow);
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

