/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityGoblin;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityGoblinGangster
extends EntityGoblin {
    private static final AnimatedAction DOUBLE_STAB = AnimatedAction.builder((double)0.88, (String)"double_stab").marker("attack", new double[]{0.4, 0.72}).build();
    private static final AnimatedAction DOUBLE_THROW = AnimatedAction.builder((double)0.96, (String)"double_throw").marker("attack", new double[]{0.4, 0.76}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)DOUBLE_THROW, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DOUBLE_STAB, DOUBLE_THROW, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityGoblinGangster>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(DOUBLE_STAB, e -> 0.8f), (int)2), WeightedEntry.m_146290_((Object)MonsterActionUtils.simpleRangedEvadingAction(DOUBLE_THROW, 8.0, 3.0, 1.0, e -> 1.0f).withCondition((goal, target, previous) -> !((EntityGoblinGangster)goal.attacker).m_21205_().m_41619_()), (int)3));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityGoblinGangster>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityGoblinGangster> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGoblinGangster> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityGoblinGangster(EntityType<? extends EntityGoblin> type, Level level) {
        super(type, level);
        this.f_21345_.m_25363_(((EntityGoblin)this).attack);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.CUTLASS_PROP.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ModItems.CUTLASS_PROP.get()));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 1 ? (Spell)((Object)ModSpells.THROW_HAND_ITEM.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(DOUBLE_THROW);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_STAB);
            }
        }
    }

    public AnimationHandler<EntityGoblinGangster> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.5;
        double length = (double)this.m_20205_() * 2.15;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DOUBLE_THROW})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                if (this.m_5448_() != null && this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                    ((Spell)((Object)ModSpells.THROW_HAND_ITEM.get())).use((LivingEntity)this);
                }
                this.m_5810_();
            }
        } else if (anim.is(new AnimatedAction[]{DOUBLE_STAB})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.m_5448_(), this::quickAttack);
            }
        }
    }

    public boolean quickAttack(Entity target) {
        CustomDamage.Builder source = new CustomDamage.Builder((Entity)this).noKnockback().hurtResistant(1);
        return CombatUtils.mobAttack((LivingEntity)this, target, source);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

