/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityLeafBall
extends BaseMonster {
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.68, (String)"tackle").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction WIND = AnimatedAction.builder((double)1.12, (String)"wind_blade").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction SLEEP_ATTACK = AnimatedAction.builder((double)0.8, (String)"sleep_aura").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, WIND, SLEEP_ATTACK, INTERACT, STILL};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityLeafBall>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(MELEE, e -> 0.7f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(WIND, 10.0, 4.0, 1.0, e -> 1.0f), (int)3), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(SLEEP_ATTACK, 7.0, 1.0, 1.0, e -> 1.0f), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityLeafBall>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)3));
    public final AnimatedAttackGoal<EntityLeafBall> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityLeafBall> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityLeafBall(EntityType<? extends EntityLeafBall> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
        this.m_20242_(true);
        this.f_21342_ = new FreeMoveControl((Mob)this, 60.0f, 30.0f, () -> true);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        this.m_21051_(Attributes.f_22280_).m_22100_(0.28);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<Player>((Mob)this, Player.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetHorizontal<Mob>((Mob)this, Mob.class, 5, true, true, this.targetPred);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{WIND})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DOUBLE_SONIC.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{SLEEP_ATTACK})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.SLEEP_AURA.get())).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.4;
        double length = this.m_20205_() * 2.0f;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 0 ? (Spell)((Object)ModSpells.DOUBLE_BULLET.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.m_21187_().nextInt(20) + 30 + diffAdd;
        }
        return this.m_21187_().nextInt(40) + 25 + diffAdd;
    }

    public AnimationHandler<EntityLeafBall> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.0, -0.375);
    }
}

