/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMage
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimatedAction SWING = AnimatedAction.builder((double)0.64, (String)"swing").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction CAST_1 = AnimatedAction.builder((double)0.84, (String)"cast_1").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction CAST_DOUBLE = AnimatedAction.builder((double)0.84, (String)"cast_double").marker("attack", new double[]{0.4, 0.6}).build();
    public static final AnimatedAction CAST_2 = AnimatedAction.builder((double)0.92, (String)"cast_2").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWING, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SWING, CAST_1, CAST_2, CAST_DOUBLE, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityMage>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(SWING, e -> 0.8f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedStrafingAction(CAST_1, 6.0f, 1.0f, e -> 1.0f), (int)3), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedStrafingAction(CAST_DOUBLE, 7.0f, 1.0f, e -> 1.0f), (int)2), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedStrafingAction(CAST_2, 8.0f, 1.0f, e -> 1.0f), (int)4));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityMage>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)1), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityMage> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMage> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final Predicate<LivingEntity> healingPredicate = e -> {
        if (this.m_142504_() == null) {
            OwnableEntity ownable;
            if (e instanceof OwnableEntity && (ownable = (OwnableEntity)e).m_142504_() != null) {
                return false;
            }
            return e instanceof Enemy && e != this.m_5448_();
        }
        if (e instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)e;
            if (this.m_142504_().equals(ownable.m_142504_())) {
                return true;
            }
        }
        return this.m_142504_().equals(e.m_142081_());
    };

    public EntityMage(EntityType<? extends EntityMage> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 2.1;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{CAST_1})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                this.getFirstSpell().use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{CAST_DOUBLE})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DARK_BALL.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{CAST_2})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                this.getSecondSpell().use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            Spell spell;
            switch (command) {
                case 2: {
                    Spell spell2 = this.getSecondSpell();
                    break;
                }
                case 1: {
                    Spell spell2 = this.getFirstSpell();
                    break;
                }
                default: {
                    Spell spell2 = spell = null;
                }
            }
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), spell)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CAST_2);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(CAST_1);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    public AnimationHandler<EntityMage> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<LivingEntity> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    public Spell getFirstSpell() {
        return (Spell)((Object)ModSpells.PARALYSIS_BALL.get());
    }

    public Spell getSecondSpell() {
        return (Spell)((Object)ModSpells.EXPANDING_QUAD_LIGHT.get());
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.84375, -0.3125);
    }
}

