/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RiderAttackTargetGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.StayGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityMimic
extends LeapingMonster {
    private static final EntityDataAccessor<Boolean> AWAKE = SynchedEntityData.m_135353_(EntityMimic.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.6, (String)"attack").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction LEAP = AnimatedAction.builder((double)0.6, (String)"leap").marker("attack", new double[]{0.2}).build();
    private static final AnimatedAction THROW = AnimatedAction.builder((double)0.6, (String)"throw").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction ARROW = AnimatedAction.copyOf((AnimatedAction)THROW, (String)"arrow");
    private static final AnimatedAction CAST = AnimatedAction.builder((double)0.6, (String)"cast").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction CLOSE = AnimatedAction.builder((double)0.32, (String)"close").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, THROW, ARROW, CAST, CLOSE, INTERACT};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityMimic>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.8f), (int)8), WeightedEntry.m_146290_((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 3))), (int)8), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(THROW, 9.0, 3.0, 1.0, e -> 1.0f), (int)4), WeightedEntry.m_146290_((Object)new GoalAttackAction(THROW).cooldown(e -> e.animationCooldown(THROW)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)3), WeightedEntry.m_146290_((Object)new GoalAttackAction(ARROW).cooldown(e -> e.animationCooldown(ARROW)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.0, 2))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(CAST).cooldown(e -> e.animationCooldown(CAST)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.0, 2))), (int)6));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityMimic>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 1.5)), (int)1), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityMimic> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMimic> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private int sleepTick = -1;
    private boolean sleeping;
    private final List<ItemStack> throwables = List.of(new ItemStack((ItemLike)Items.f_42410_), new ItemStack((ItemLike)ModItems.BATTLE_AXE.get()), new ItemStack((ItemLike)ModItems.STEEL_SWORD.get()), new ItemStack((ItemLike)ModItems.MUSHROOM.get()));

    public EntityMimic(EntityType<? extends EntityMimic> type, Level world) {
        super((EntityType<? extends LeapingMonster>)type, world);
        this.f_21345_.m_25352_(2, this.attack);
        this.f_21342_ = new JumpingMover(this);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
    }

    @Override
    public void addGoal() {
        this.f_21346_.m_25352_(1, (Goal)this.targetPlayer);
        this.f_21346_.m_25352_(2, (Goal)this.targetMobs);
        this.f_21346_.m_25352_(0, (Goal)this.hurt);
        this.f_21346_.m_25352_(3, (Goal)new RiderAttackTargetGoal((Mob)this, 15));
        this.f_21345_.m_25352_(0, (Goal)this.swimGoal);
        this.f_21345_.m_25352_(0, new StayGoal<BaseMonster>(this, StayGoal.CANSTAYMONSTER));
        this.f_21345_.m_25352_(3, (Goal)this.followOwnerGoal);
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean ret = super.m_6469_(source, amount);
        if (ret && !this.sleeping) {
            this.setAwake();
        }
        return ret;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.6;
        double length = (double)this.m_20205_() * 1.8;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.THROW_HAND_ITEM.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(THROW);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AWAKE, (Object)false);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{THROW})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ItemStack held = this.m_21205_();
                this.m_8061_(EquipmentSlot.MAINHAND, this.throwables.get(this.f_19796_.nextInt(this.throwables.size())));
                ((Spell)((Object)ModSpells.THROW_HAND_ITEM.get())).use((LivingEntity)this);
                this.m_8061_(EquipmentSlot.MAINHAND, held);
            }
        } else if (anim.is(new AnimatedAction[]{CAST})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.WATER_LASER.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{ARROW})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DOUBLE_ARROW.get())).use((LivingEntity)this);
            }
        } else {
            if (!this.isLeapingAnim(anim)) {
                Vec3 vec32 = this.getLeapVec(this.tryGetTargetPosition(this.m_5448_())).m_82490_(0.1);
                this.m_20334_(vec32.f_82479_, 0.05f, vec32.f_82481_);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    public Vec3 getLeapVec(@Nullable Vec3 target) {
        return super.getLeapVec(target).m_82490_(1.25);
    }

    @Override
    public double leapHeightMotion() {
        return 0.3;
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        super.m_6710_(livingEntity);
        if (livingEntity != null && !this.sleeping) {
            this.setAwake();
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() == null) {
                --this.sleepTick;
            }
            if (this.sleepTick == 0) {
                this.f_19804_.m_135381_(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.m_21573_().m_26573_();
            }
        }
    }

    public void setAwake() {
        this.f_19804_.m_135381_(AWAKE, (Object)true);
        this.sleepTick = 200;
    }

    protected float m_6118_() {
        if (this.m_5448_() != null) {
            return 0.28f * this.m_20098_();
        }
        return 0.48f * this.m_20098_();
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    public boolean isAwake() {
        return (Boolean)this.f_19804_.m_135370_(AWAKE);
    }

    public AnimationHandler<? extends EntityMimic> getAnimationHandler() {
        return this.animationHandler;
    }

    private int getJumpDelay() {
        if (this.m_5448_() != null) {
            return this.f_19796_.nextInt(5) + 5;
        }
        return this.f_19796_.nextInt(6) + 7;
    }

    public boolean m_5829_() {
        return !this.isAwake();
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            this.sleeping = true;
            if (this.isAwake()) {
                this.f_19804_.m_135381_(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.m_21573_().m_26573_();
            }
        } else {
            this.sleeping = false;
        }
    }

    @Override
    public boolean hasSleepingAnimation() {
        return true;
    }

    protected static class JumpingMover
    extends MoveControl {
        private final EntityMimic mimic;
        private int jumpDelay;

        public JumpingMover(EntityMimic mimic) {
            super((Mob)mimic);
            this.mimic = mimic;
        }

        public void m_8126_() {
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            this.mimic.setAwake();
            this.f_24981_ = MoveControl.Operation.WAIT;
            double dX = this.f_24975_ - this.f_24974_.m_20185_();
            double dZ = this.f_24977_ - this.f_24974_.m_20189_();
            float n = (float)(Mth.m_14136_((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), n, 90.0f));
            if (this.f_24974_.m_20096_()) {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.mimic.getJumpDelay();
                    this.mimic.m_21569_().m_24901_();
                    this.mimic.m_5496_(SoundEvents.f_11749_, this.mimic.m_6121_() * 0.5f, 1.0f);
                } else {
                    this.mimic.f_20900_ = 0.0f;
                    this.mimic.f_20902_ = 0.0f;
                    this.f_24974_.m_7910_(0.0f);
                }
            } else {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            }
        }
    }
}

