/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMinotaur
extends ChargingMonster {
    public static final AnimatedAction SWING = AnimatedAction.builder((double)1.08, (String)"swing").marker("attack", new double[]{0.72}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)1.48, (String)"spin").marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{1.28}).marker("reset", new double[]{0.84}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)2.64, (String)"charge").marker("attack_start", new double[]{0.64}).marker("attack_end", new double[]{2.2}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWING, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SWING, SPIN, CHARGE, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityMinotaur>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SWING, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SPIN, e -> 1.0f), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE)).withCondition(MonsterActionUtils.chargeCondition()).prepare(ChargeAction::new), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityMinotaur>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)5));
    public final AnimatedAttackGoal<EntityMinotaur> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMinotaur> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private Vec3 spinDirection;
    private float spinAngle;

    public EntityMinotaur(EntityType<? extends EntityMinotaur> type, Level world) {
        super((EntityType<? extends ChargingMonster>)type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimatedAction)anim);
            if (!this.f_19853_.f_46443_ && (anim == null || anim.is(new AnimatedAction[]{SPIN}))) {
                this.hitEntity = null;
                this.spinDirection = null;
            }
        };
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            double attackSize = (double)this.m_20205_() * 1.4;
            return new AABB(-attackSize, -0.2, -attackSize, attackSize, (double)this.m_20206_() + 0.2, attackSize);
        }
        double width = (double)this.m_20205_() * 1.6;
        double length = (double)this.m_20205_() * 2.1;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList();
            }
            if (this.spinDirection == null) {
                this.spinDirection = EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.1);
                this.spinAngle = this.m_146908_() + 90.0f;
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                this.m_20334_(this.spinDirection.m_7096_(), this.m_20184_().f_82480_, this.spinDirection.m_7094_());
                float start = (float)(anim.getMarker("attack_start", 0) * 20.0);
                float end = (float)(anim.getMarker("attack_end", 0) * 20.0);
                float f = anim.progress(start, end, 1.0f, 0);
                float fNext = anim.progress(start, end, 1.0f, 1);
                float angleInc = -490.0f;
                if (anim.isAt("reset")) {
                    this.hitEntity.clear();
                }
                this.hitEntity.addAll(CombatUtils.EntityAttack.create((LivingEntity)this, CombatUtils.EntityAttack.circleTargetsFixedRange(this.spinAngle + f * angleInc, this.spinAngle + fNext * angleInc, 4.5f)).withTargetPredicate(e -> this.hitPred.test(e) && !this.hitEntity.contains(e)).executeAttack());
            }
        } else {
            if (anim.is(new AnimatedAction[]{SWING}) && anim.isAt("attack")) {
                S2CScreenShake.sendAround((Entity)this, 16.0, 5, 3.0f);
                this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 0.9f);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            source.knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f);
        } else if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SWING})) {
            source.withChangedAttribute((Attribute)ModAttributes.STUN.get(), 30.0);
        }
        return source;
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{CHARGE});
    }

    @Override
    public boolean handleChargeMovement(AnimatedAction anim) {
        boolean res = super.handleChargeMovement(anim);
        if (res && this.f_19797_ % 7 == 0) {
            this.m_5496_((SoundEvent)ModSounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
        }
        return res;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    public AnimationHandler<? extends EntityMinotaur> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public double chargingSpeed() {
        return 0.45f;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 2.3125, -0.4375);
    }
}

