/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMobArrow;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityOrcArcher;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityOrcHunter
extends EntityOrcArcher {
    public EntityOrcHunter(EntityType<? extends EntityOrcHunter> type, Level level) {
        super((EntityType<? extends EntityOrcArcher>)type, level);
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{EntityOrcArcher.RANGED})) {
            this.m_6672_(InteractionHand.MAIN_HAND);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{EntityOrcArcher.RANGED})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                if (this.m_5448_() != null && this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                    this.shootTripleArrow(this.m_5448_());
                } else if (this.m_146895_() instanceof Player) {
                    this.shootTripleArrowFromRotation((LivingEntity)this);
                }
                this.m_5810_();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    private void shootTripleArrow(LivingEntity target) {
        EntityMobArrow arrow = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
        Vec3 dir = new Vec3(target.m_20185_() - arrow.m_20185_(), target.m_20227_(0.33) - arrow.m_20186_(), target.m_20189_() - arrow.m_20189_());
        double l = Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_);
        dir = dir.m_82520_(0.0, l * 0.2, 0.0);
        arrow.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
        this.f_19853_.m_7967_((Entity)arrow);
        Vec3 up = this.m_20289_(1.0f);
        for (float y = -15.0f; y <= 15.0f; y += 30.0f) {
            Quaternion quaternion = new Quaternion(new Vector3f(up), y, true);
            Vector3f newDir = new Vector3f(dir);
            newDir.m_122251_(quaternion);
            EntityMobArrow arrowO = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
            arrowO.m_6686_(newDir.m_122239_(), newDir.m_122260_(), newDir.m_122269_(), 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
            this.f_19853_.m_7967_((Entity)arrowO);
        }
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
    }

    private void shootTripleArrowFromRotation(LivingEntity shooter) {
        for (int i = 0; i < 3; ++i) {
            EntityMobArrow arrow = new EntityMobArrow(this.f_19853_, (LivingEntity)this, 0.8f);
            arrow.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_() + (float)((i - 1) * 15), 0.0f, 1.3f, 7 - this.f_19853_.m_46791_().m_19028_() * 2);
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)arrow);
        }
    }
}

