/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityPalmCat
extends LeapingMonster {
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.72, (String)"attack").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction LEAP = AnimatedAction.builder((double)0.76, (String)"attack_2").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{0.64}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityPalmCat>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(MELEE, e -> e.consecutive ? 1.0f : 0.7f), (int)4), WeightedEntry.m_146290_((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 3.0))), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityPalmCat>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)1));
    public final AnimatedAttackGoal<EntityPalmCat> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityPalmCat> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private boolean hitAny;
    private boolean consecutive;

    public EntityPalmCat(EntityType<? extends EntityPalmCat> type, Level world) {
        super((EntityType<? extends LeapingMonster>)type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimatedAction)anim);
            if (!this.f_19853_.f_46443_) {
                AnimatedAction current = this.animationHandler.getAnimation();
                if (MELEE.is(new AnimatedAction[]{current}) || LEAP.is(new AnimatedAction[]{current})) {
                    if (this.hitAny && !this.consecutive) {
                        this.consecutive = true;
                        this.attack.resetCooldown();
                    } else {
                        this.consecutive = false;
                    }
                }
                this.hitAny = false;
            }
        };
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    public AnimationHandler<? extends EntityPalmCat> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Vec3 getLeapVec(@Nullable Vec3 target) {
        if (target != null) {
            Vec3 leap = new Vec3(target.f_82479_ - this.m_20185_(), 0.0, target.f_82481_ - this.m_20189_());
            if (leap.m_82556_() > 7.0) {
                return leap.m_82541_();
            }
            return leap.m_82490_(0.9);
        }
        return super.getLeapVec(null);
    }

    @Override
    public double leapHeightMotion() {
        return 0.2;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean hurt;
        CustomDamage.Builder source = new CustomDamage.Builder((Entity)this).noKnockback().hurtResistant(1);
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
            source.knock(CustomDamage.KnockBackType.UP).knockAmount(1.0f);
        }
        if (hurt = CombatUtils.mobAttack((LivingEntity)this, entity, source)) {
            this.hitAny = true;
        }
        return hurt;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.3;
        double length = (double)this.m_20205_() * 2.1;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.984375, -0.25);
    }
}

