/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.StaticNavigator;
import io.github.flemmli97.runecraftory.common.entities.misc.SarcophagusTeleporter;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class EntitySanoUno
extends BossMonster {
    private static final EntityDataAccessor<Boolean> CAN_BE_REMOVED = SynchedEntityData.m_135353_(EntitySanoUno.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private UUID linkedID;
    protected boolean reversedSwipe;
    protected Vec3 targetPos;

    public EntitySanoUno(EntityType<? extends EntitySanoUno> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        this.f_21365_ = new NonLookControl((Mob)this);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.SANO_UNO_FIGHT.get());
    }

    public void linkUsing(UUID uuid) {
        this.linkedID = uuid;
        this.bossInfo.setMusicID(this.linkedID);
    }

    @Nullable
    public UUID getLinkedID() {
        return this.linkedID;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_BE_REMOVED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.linkedID != null) {
            compound.m_128362_("LinkedID", this.linkedID);
        }
        compound.m_128379_("CanBeRemoved", ((Boolean)this.f_19804_.m_135370_(CAN_BE_REMOVED)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("LinkedID")) {
            this.linkedID = compound.m_128342_("LinkedID");
        }
        this.f_19804_.m_135381_(CAN_BE_REMOVED, (Object)compound.m_128471_("CanBeRemoved"));
    }

    protected PathNavigation m_6037_(Level level) {
        return new StaticNavigator((Mob)this, level);
    }

    public void m_5997_(double x, double y, double z) {
    }

    public void m_21391_(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
    }

    @Override
    protected Vec3 directionToLookAt() {
        return null;
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public void m_7023_(Vec3 vec) {
        this.f_20900_ = 0.0f;
        this.f_20901_ = 0.0f;
        this.f_20902_ = 0.0f;
        this.m_20334_(0.0, this.m_20184_().f_82480_ - 0.08, 0.0);
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    @Override
    protected boolean checkRage() {
        return false;
    }

    @Override
    public void playInteractionAnimation() {
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19310_) {
            return false;
        }
        if (source == DamageSource.f_19317_ && this.f_20919_ == this.maxDeathTime() - 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected void m_6153_() {
        EntitySanoUno other;
        if (!this.f_19853_.f_46443_ && this.f_20919_ == 0 && (other = this.getLinked()) != null && !((Boolean)this.f_19804_.m_135370_(CAN_BE_REMOVED)).booleanValue()) {
            other.f_19804_.m_135381_(CAN_BE_REMOVED, (Object)true);
        }
        if (this.f_20919_ == this.maxDeathTime() - 1) {
            if (this.f_19853_.f_46443_) {
                return;
            }
            other = this.getLinked();
            if (!((Boolean)this.f_19804_.m_135370_(CAN_BE_REMOVED)).booleanValue() && other != null && !other.m_146910_()) {
                return;
            }
        }
        super.m_6153_();
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_ && reason == Entity.RemovalReason.KILLED && this.linkedID != null) {
            Vec3 dir = Vec3.m_82498_((float)0.0f, (float)this.m_146908_());
            SarcophagusTeleporter teleporter = new SarcophagusTeleporter((EntityType)ModEntities.SARCOPHAGUS_TELEPORTER.get(), this.f_19853_);
            teleporter.m_146884_(this.m_20182_().m_82549_(dir.m_82490_(-2.0)));
            this.f_19853_.m_7967_((Entity)teleporter);
        }
        super.m_142687_(reason);
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.90625, 0.375).m_82490_(2.0);
    }

    @Override
    public boolean reversed() {
        return this.reversedSwipe;
    }

    public abstract EntitySanoUno getLinked();

    static class NonLookControl
    extends LookControl {
        public NonLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            boolean b = false;
        }
    }
}

