/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySkyFish
extends BaseMonster {
    public static final AnimatedAction SLAP = AnimatedAction.builder((double)0.56, (String)"slap").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction BEAM = AnimatedAction.builder((double)0.68, (String)"beam").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction SWIPE = AnimatedAction.builder((double)0.76, (String)"swipe").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SLAP, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SLAP, BEAM, SWIPE, INTERACT, STILL};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntitySkyFish>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SLAP, e -> 0.6f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(BEAM, 8.0, 5.0, 1.0, e -> 1.0f), (int)2), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(SWIPE, 8.0, 5.0, 1.0, e -> 1.0f), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntitySkyFish>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(10.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntitySkyFish> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySkyFish> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntitySkyFish(EntityType<? extends BaseMonster> type, Level world) {
        super(type, world);
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new AirWanderGoal(this);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21345_.m_25352_(2, this.attack);
        this.f_21342_ = new FreeMoveControl((Mob)this, () -> false);
        this.f_21345_.m_25363_((Goal)this.swimGoal);
        this.wander.m_25746_(50);
        this.m_20242_(true);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<Player>((Mob)this, Player.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetHorizontal<Mob>((Mob)this, Mob.class, 5, true, true, this.targetPred);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && !this.m_20069_() && this.belowSoldid()) {
            Vec3 mot = this.m_20184_();
            double newY = Math.max(0.0, mot.f_82480_);
            this.m_20334_(mot.f_82479_, Math.min(0.3, newY += 0.03), mot.f_82481_);
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        this.handleFreeTravel(vec);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.5;
        double length = (double)this.m_20205_() * 1.6;
        return new AABB(-width * 0.2, -0.02, 0.0, width * 0.8, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BEAM})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.WATER_LASER.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{SWIPE})) {
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.WATER_SWIPE.get())).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 1) {
                if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.WATER_LASER.get()))) {
                    return;
                }
                this.getAnimationHandler().setAnimation(BEAM);
            } else {
                if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                    return;
                }
                if (command == 2) {
                    this.getAnimationHandler().setAnimation(SWIPE);
                } else {
                    this.getAnimationHandler().setAnimation(SLAP);
                }
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 0.8f;
    }

    public AnimationHandler<EntitySkyFish> getAnimationHandler() {
        return this.animationHandler;
    }

    private boolean belowSoldid() {
        BlockPos pos = this.m_142538_().m_7495_();
        return this.f_19853_.m_8055_(pos).m_60634_((BlockGetter)this.f_19853_, pos, (Entity)this);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean m_6146_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.75, -0.125);
    }
}

