/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySpider
extends BaseMonster {
    private static final EntityDataAccessor<Boolean> CLIMBING_SYNC = SynchedEntityData.m_135353_(EntitySpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.6, (String)"attack").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction WEBSHOT = AnimatedAction.builder((double)0.68, (String)"webshot").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, WEBSHOT, INTERACT, STILL};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntitySpider>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.7f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedStrafingAction(WEBSHOT, 7.0f, 1.0f, e -> 1.0f), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntitySpider>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)5), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(9.0, 3)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntitySpider> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySpider> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    public int climbingTicker = -1;
    public static final int CLIMB_MAX = 9;

    public EntitySpider(EntityType<? extends EntitySpider> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.27);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING_SYNC, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        this.climbingTicker = this.isClimbing() && this.m_6084_() && !this.playDeath() ? Math.min(this.climbingTicker + 1, 9) : Math.max(this.climbingTicker - 1, -1);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING_SYNC);
    }

    public void setClimbing(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING_SYNC, (Object)climbing);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12434_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.3f;
    }

    public AnimationHandler<EntitySpider> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.5;
        double length = (double)this.m_20205_() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{WEBSHOT})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack") && (this.m_5448_() != null && this.m_21574_().m_148306_((Entity)this.m_5448_()) || this.m_146895_() instanceof Player)) {
                ((Spell)((Object)ModSpells.WEB_SHOT.get())).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 1 ? (Spell)((Object)ModSpells.WEB_SHOT.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(WEBSHOT);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return (int)((double)(super.m_5639_(distance, damageMultiplier) - 3) * 0.5);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.625, 0.21875);
    }
}

