/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AmphibiousStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.SwimWalkMoveController;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.AmphibiousNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityTortas
extends ChargingMonster {
    public static final AnimatedAction BITE = AnimatedAction.builder((double)0.56, (String)"bite").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)2.5, (String)"spin").marker("attack_start", new double[]{0.0}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)BITE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{BITE, SPIN, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityTortas>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(BITE, e -> 0.85f), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(SPIN).cooldown(e -> e.animationCooldown(SPIN)).withCondition(MonsterActionUtils.chargeCondition()).prepare(ChargeAction::new), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityTortas>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)5), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityTortas> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityTortas> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    protected final WaterBoundPathNavigation waterNavigator;
    protected final GroundPathNavigation groundNavigator;

    public EntityTortas(EntityType<? extends EntityTortas> type, Level world) {
        super((EntityType<? extends ChargingMonster>)type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21345_.m_25352_(2, this.attack);
        this.f_21342_ = new SwimWalkMoveController((Mob)this);
        this.f_21345_.m_25363_((Goal)this.swimGoal);
        this.waterNavigator = new AmphibiousNavigator((Mob)this, world);
        this.groundNavigator = new GroundPathNavigation((Mob)this, world);
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new AmphibiousStrollGoal(this, 1.0, 2);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
        this.f_19793_ = 1.0f;
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.18);
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        if (anim != null && anim.is(new AnimatedAction[]{SPIN})) {
            int diffAdd = this.difficultyCooldown();
            return this.m_21187_().nextInt(50) + 30 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public void setDoJumping(boolean jump) {
        if (this.m_20069_()) {
            super.setDoJumping(jump);
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        if (this.m_6142_() && this.m_20069_()) {
            this.handleFreeTravel(vec);
        } else {
            super.m_7023_(vec);
        }
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.2;
        double length = (double)this.m_20205_() * 1.4;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{SPIN});
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim != null && anim.is(new AnimatedAction[]{SPIN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82400_(0.2), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(BITE);
            }
        }
    }

    @Override
    public double ridingSpeedModifier() {
        return 0.8;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12536_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12531_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 0.75f;
    }

    public AnimationHandler<EntityTortas> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean adjustRotFromRider(LivingEntity rider) {
        return true;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SPIN})) {
            return this.m_20184_();
        }
        return super.directionToLookAt();
    }

    @Override
    public boolean handleChargeMovement(AnimatedAction anim) {
        Vec3 prevMotion = this.m_20184_();
        if (this.m_5448_() != null) {
            Vec3 pos = this.m_20182_();
            Vec3 target = this.m_5448_().m_20182_();
            Vec3 mot = target.m_82492_(pos.f_82479_, this.m_20069_() ? pos.f_82480_ : target.f_82480_, pos.f_82481_).m_82541_().m_82490_(0.27);
            this.m_20334_(mot.f_82479_, mot.f_82480_, mot.f_82481_);
            if (!this.m_20096_() && !this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, prevMotion.f_82480_, 0.0));
            }
        } else {
            Vec3 look = this.m_20171_(this.m_20069_() ? this.m_146909_() : 0.0f, this.m_146908_()).m_82490_(0.27);
            this.m_20334_(look.f_82479_, look.f_82480_, look.f_82481_);
            if (!this.m_20096_() && !this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, prevMotion.f_82480_, 0.0));
            }
        }
        return true;
    }

    @Override
    public void doWhileCharge() {
        if (this.f_19797_ % 4 == 0) {
            this.m_5496_((SoundEvent)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (this.m_21187_().nextFloat() - this.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        if (this.f_19797_ % 8 == 0) {
            this.hitEntity.clear();
        }
    }

    @Override
    public double chargingSpeed() {
        return 0.3f;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                this.f_21344_ = this.waterNavigator;
                this.wander.m_25746_(2);
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigator;
                this.wander.m_25746_(100);
                this.m_20282_(false);
            }
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.7;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.6875, -0.25);
    }
}

