/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityBigMuck;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

public class EntityTrickyMuck
extends EntityBigMuck {
    public static final AnimatedAction SPORE_BALL = AnimatedAction.copyOf((AnimatedAction)SPORE, (String)"spore_ball");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SLAP, SPORE, SPORE_BALL, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityTrickyMuck>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(SLAP, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SPORE, e -> 1.0f), (int)2), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(SPORE_BALL, 8.0, 3.0, 1.0, e -> 1.0f), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityTrickyMuck>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 4)), (int)1));
    public final AnimatedAttackGoal<EntityTrickyMuck> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityBigMuck> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityTrickyMuck(EntityType<? extends EntityTrickyMuck> type, Level world) {
        super((EntityType<? extends EntityBigMuck>)type, world);
        this.f_21345_.m_25363_(((EntityBigMuck)this).attack);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    public AnimationHandler<EntityBigMuck> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPORE_BALL})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.POISON_BALL.get())).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.POISON_BALL.get()) : null)) {
                return;
            }
            if (command == 2 && this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.POISON_BALL.get()))) {
                this.getAnimationHandler().setAnimation(SPORE_BALL);
            }
            if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.SPORE_CIRCLE_SPELL.get()))) {
                    this.getAnimationHandler().setAnimation(SPORE);
                }
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }
}

