/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityTroll
extends BaseMonster {
    public static final AnimatedAction PUNCH = AnimatedAction.builder((double)0.8, (String)"punch").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction DOUBLE_PUNCH = AnimatedAction.builder((double)0.8, (String)"double_fist_punch").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction SLAM = AnimatedAction.builder((double)0.8, (String)"fist_slam").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)PUNCH, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{PUNCH, DOUBLE_PUNCH, SLAM, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityTroll>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(PUNCH, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(DOUBLE_PUNCH, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SLAM, e -> 1.0f), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityTroll>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 4)), (int)1));
    public final AnimatedAttackGoal<EntityTroll> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityTroll> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityTroll(EntityType<? extends EntityTroll> type, Level world) {
        super(type, world);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.23);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{SLAM})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SLAM})) {
            double range = (double)this.m_20205_() * 2.1;
            return new AABB(-range * 0.5, -0.02, -range * 0.25, range * 0.5, (double)this.m_20206_() + 0.02, range * 0.75);
        }
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 1.8;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void mobAttack(AnimatedAction anim, LivingEntity target, Consumer<LivingEntity> cons) {
        super.mobAttack(anim, target, cons);
        if (anim.is(new AnimatedAction[]{SLAM})) {
            S2CScreenShake.sendAround((Entity)this, 16.0, 10, 2.0f);
            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.0f);
        }
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SLAM, DOUBLE_PUNCH})) {
            source.withChangedAttribute((Attribute)ModAttributes.STUN.get(), 30.0);
        }
        return source;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(SLAM);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(DOUBLE_PUNCH);
            } else {
                this.getAnimationHandler().setAnimation(PUNCH);
            }
        }
    }

    public AnimationHandler<EntityTroll> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 2.3125, -0.375);
    }
}

