/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityVeggieGhost
extends BaseMonster {
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)1.16, (String)"head_attack").marker("attack", new double[]{0.68}).build();
    public static final AnimatedAction CAST = AnimatedAction.builder((double)0.68, (String)"cast").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)0.68, (String)"spin").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction VANISH = AnimatedAction.builder((double)5.0, (String)"vanish").marker("attack", new double[]{2.5}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)CAST, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{ATTACK, CAST, SPIN, VANISH, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityVeggieGhost>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionCondition(ATTACK, e -> 1.0f, ActionUtils.ranged((double)8.0)), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionCondition(SPIN, e -> 1.0f, ActionUtils.ranged((double)8.0)), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(CAST, 10.0, 5.0, 1.0, e -> 1.0f), (int)2), WeightedEntry.m_146290_((Object)new GoalAttackAction(VANISH).withCondition((goal, target, previous) -> ((EntityVeggieGhost)goal.attacker).shouldVanishNext(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityVeggieGhost>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(16.0f, 5.0f)), (int)1));
    public final AnimatedAttackGoal<EntityVeggieGhost> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityVeggieGhost> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (anim != null && anim.is(new AnimatedAction[]{VANISH})) {
            this.vanishNext = (double)this.m_21187_().nextFloat() < 0.6;
        }
        return false;
    });
    private boolean vanishNext;

    public EntityVeggieGhost(EntityType<? extends EntityVeggieGhost> type, Level world) {
        super(type, world);
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new AirWanderGoal(this);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
        this.f_21345_.m_25363_((Goal)this.swimGoal);
        this.f_21345_.m_25352_(2, this.attack);
        this.f_19794_ = true;
        this.f_21342_ = new FreeMoveControl((Mob)this);
        this.m_20242_(true);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        this.m_21051_(Attributes.f_22280_).m_22100_(0.35);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<Player>((Mob)this, Player.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetHorizontal<Mob>((Mob)this, Mob.class, 5, true, true, this.targetPred);
    }

    @Override
    public void m_7023_(Vec3 vec) {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.f_19794_ = entity2.f_19794_;
        } else {
            boolean bl = this.f_19794_ = !this.playDeath();
            if (this.m_20186_() < (double)(this.f_19853_.m_141937_() + 1)) {
                vec = new Vec3(vec.f_82479_, 0.006, vec.f_82481_);
            }
        }
        this.handleFreeTravel(vec);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            double attackSize = (double)this.m_20205_() * 1.4;
            return new AABB(-attackSize, -0.2, -attackSize, attackSize, (double)this.m_20206_() + 0.2, attackSize);
        }
        double width = (double)this.m_20205_() * 1.6;
        double length = this.m_20205_() * 2.0f;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{CAST})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.TRIPLE_FIRE_BALL.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{VANISH})) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                LivingEntity target = this.m_5448_();
                if (target == null) {
                    double rX = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 16.0;
                    double rY = this.m_20186_() + (this.f_19796_.nextDouble() - 0.5) * 4.0;
                    double rZ = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 16.0;
                    this.teleport(rX, rY, rZ);
                } else {
                    this.teleportTowards((Entity)target);
                }
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{VANISH})) {
            return false;
        }
        boolean ret = super.m_6469_(source, amount);
        if (ret) {
            this.vanishNext = (double)this.m_21187_().nextFloat() < 0.4;
        }
        return ret;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 1 ? (Spell)((Object)ModSpells.TRIPLE_FIRE_BALL.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CAST);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_GHOST_AMBIENT.get();
    }

    private void teleportTowards(Entity entity) {
        Vec3 look = new Vec3(entity.m_20154_().f_82479_, 0.0, entity.m_20154_().f_82481_).m_82541_().m_82490_(-1.5);
        Vec3 behindEntity = entity.m_20182_().m_82549_(look);
        Vec3 dir = new Vec3(behindEntity.f_82479_ - this.m_20185_(), behindEntity.f_82480_ - this.m_20186_(), behindEntity.f_82481_ - this.m_20189_());
        if (dir.m_82556_() < 100.0) {
            this.teleport(behindEntity.f_82479_, behindEntity.f_82480_, behindEntity.f_82481_);
        } else {
            dir = dir.m_82541_();
            double e = this.m_20185_() + this.f_19796_.nextDouble() * 9.0 * dir.f_82479_;
            double g = this.m_20189_() + this.f_19796_.nextDouble() * 9.0 * dir.f_82481_;
            this.teleport(e, entity.m_20186_(), g);
        }
    }

    private void teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)mutableBlockPos).m_60767_().m_76334_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.f_19853_.m_8055_((BlockPos)mutableBlockPos);
        if (!blockState.m_60767_().m_76334_()) {
            y = this.m_20186_();
        }
        this.m_6021_(x, y + 1.0, z);
    }

    public boolean shouldVanishNext(String prev) {
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_20280_((Entity)this) > 140.0) {
            return true;
        }
        return this.f_19796_.nextFloat() < 0.2f || !prev.equals(VANISH.getID()) && this.vanishNext;
    }

    public AnimationHandler<EntityVeggieGhost> getAnimationHandler() {
        return this.animationHandler;
    }

    protected void m_7840_(double dist, boolean groundLogic, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.75, -0.25);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

