/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityWeagle
extends BaseMonster {
    public static final AnimatedAction GALE = AnimatedAction.builder((double)0.96, (String)"gale").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction PECK = AnimatedAction.builder((double)0.56, (String)"peck").marker("attack", new double[]{0.2}).build();
    public static final AnimatedAction SWOOP = AnimatedAction.builder((double)0.6, (String)"swoop").marker("swoop_start", new double[]{0.2}).marker("swoop_end", new double[]{0.48}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)PECK, (String)"interact");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)2.0, (String)"defeat").infinite().build();
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{GALE, PECK, SWOOP, INTERACT, DEFEAT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityWeagle>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(PECK, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeActionInRange(SWOOP, e -> 1.0f), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleRangedEvadingAction(GALE, 8.0, 4.0, 1.0, e -> 1.0f), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityWeagle>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(16.0f, 5.0f)), (int)1));
    public final AnimatedAttackGoal<EntityWeagle> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    protected List<LivingEntity> hitEntity;
    private final AnimationHandler<EntityWeagle> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.hitEntity = null;
        this.setSwoopMotion(null);
        return false;
    });
    private Vec3 swoopMotion;

    public EntityWeagle(EntityType<? extends BaseMonster> type, Level world) {
        super(type, world);
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new AirWanderGoal(this);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
        this.f_21345_.m_25352_(2, this.attack);
        this.f_21342_ = new FreeMoveControl((Mob)this, 90.0f, 50.0f, FreeMoveControl.TRUE);
        this.m_20242_(true);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22280_).m_22100_(0.33);
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<Player>((Mob)this, Player.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetHorizontal<Mob>((Mob)this, Mob.class, 5, true, true, this.targetPred);
    }

    @Override
    public void m_7023_(Vec3 vec) {
        super.handleFreeTravel(vec);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.5;
        double length = (double)this.m_20205_() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SWOOP})) {
            return this.swoopMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{GALE})) {
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.GUST_SPELL.get())).use((LivingEntity)this);
            }
        } else if (anim.is(new AnimatedAction[]{SWOOP})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList<LivingEntity>();
            }
            if (this.swoopMotion == null) {
                this.setSwoopMotion(EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.2).m_82520_(0.0, -0.3, 0.0));
            }
            if (anim.isPast("swoop_start") && !anim.isPast("swoop_end")) {
                this.m_20256_(this.swoopMotion);
                this.mobAttack(anim, null, e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((LivingEntity)e);
                        this.m_7327_((Entity)e);
                    }
                });
            } else {
                this.m_20256_(this.swoopMotion.m_82542_(-1.0, -0.7, -1.0));
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        if (anim != null && anim.is(new AnimatedAction[]{GALE})) {
            int diffAdd = this.difficultyCooldown();
            return this.m_21187_().nextInt(40) + 20 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{SWOOP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82400_(0.2).m_82400_(grow), this.m_146908_(), 0.0f, this.m_20182_().m_82549_(this.m_20184_()));
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.GUST_SPELL.get()) : null)) {
                return;
            }
            switch (command) {
                case 2: {
                    this.getAnimationHandler().setAnimation(GALE);
                    break;
                }
                case 1: {
                    this.getAnimationHandler().setAnimation(SWOOP);
                    break;
                }
                default: {
                    this.getAnimationHandler().setAnimation(PECK);
                }
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    protected void m_142043_() {
        this.m_5496_((SoundEvent)ModSounds.ENTITY_WEAGLE_FLAP.get(), this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
    }

    public AnimationHandler<EntityWeagle> getAnimationHandler() {
        return this.animationHandler;
    }

    protected void m_7840_(double dist, boolean groundLogic, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.0, -0.0625);
    }

    public void setSwoopMotion(Vec3 swoopMotion) {
        this.swoopMotion = swoopMotion;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.swoopMotion);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, charge -> {
            this.swoopMotion = charge;
        });
    }
}

