/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityWooly
extends LeapingMonster {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(EntityWooly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SPAWNSHEARED = SynchedEntityData.m_135353_(EntityWooly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final AnimatedAction SLAP = AnimatedAction.builder((double)0.76, (String)"slap").marker("attack", new double[]{0.28, 0.56}).build();
    public static final AnimatedAction KICK = AnimatedAction.builder((double)1.0, (String)"kick").marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{0.92}).build();
    public static final AnimatedAction HEADBUTT = AnimatedAction.builder((double)0.8, (String)"headbutt").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)HEADBUTT, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    public static final AnimatedAction[] ANIMS = new AnimatedAction[]{SLAP, KICK, HEADBUTT, INTERACT, SLEEP};
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityWooly>>> ATTACKS = List.of(WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(SLAP, EntityWooly::attackChance), (int)2), WeightedEntry.m_146290_((Object)new GoalAttackAction(KICK).cooldown(e -> e.animationCooldown(KICK)).withCondition(ActionUtils.chanced(EntityWooly::attackChance)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(1.5, 1.0, 4))), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(KICK).cooldown(e -> e.animationCooldown(KICK)).withCondition(ActionUtils.chanced(EntityWooly::attackChance)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 3.0))), (int)1), WeightedEntry.m_146290_(MonsterActionUtils.simpleMeleeAction(HEADBUTT, EntityWooly::attackChance), (int)2));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityWooly>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), WeightedEntry.m_146290_((Object)new IdleAction(() -> new RandomMoveAroundRunner(10.0, 5)), (int)2), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new).duration(e -> e.m_21187_().nextInt(10) + 15), (int)3));
    public final AnimatedAttackGoal<EntityWooly> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityWooly> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public EntityWooly(EntityType<? extends EntityWooly> type, Level level) {
        super((EntityType<? extends LeapingMonster>)type, level);
        this.f_21345_.m_25352_(2, this.attack);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWNSHEARED, (Object)((double)this.m_21187_().nextFloat() < 0.05 ? 1 : 0));
        this.f_19804_.m_135372_(SHEARED, (Object)((Boolean)this.f_19804_.m_135370_(SPAWNSHEARED)));
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{KICK});
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.22);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sheared", this.isSheared());
        compound.m_128379_("SpawnedSheared", ((Boolean)this.f_19804_.m_135370_(SPAWNSHEARED)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_("Sheared"));
        this.f_19804_.m_135381_(SPAWNSHEARED, (Object)compound.m_128471_("SpawnedSheared"));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(RunecraftoryTags.SHEARS)) {
            if (!(this.f_19853_.f_46443_ || this.isSheared() || this.isTamed() && !player.m_142081_().equals(this.m_142504_()))) {
                this.shear(player, itemStack);
                itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 1.9;
        if (anim.is(new AnimatedAction[]{HEADBUTT, KICK})) {
            length *= 1.5;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(KICK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(HEADBUTT);
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }

    @Override
    protected void tameEntity(Player owner) {
        super.tameEntity(owner);
        this.f_19804_.m_135381_(SPAWNSHEARED, (Object)false);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12343_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12342_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.7f;
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.m_21187_().nextInt(20) + 30 + diffAdd;
        }
        return this.m_21187_().nextInt(30) + 30 + diffAdd;
    }

    public AnimationHandler<EntityWooly> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void onDailyUpdate() {
        super.onDailyUpdate();
        if (!((Boolean)this.f_19804_.m_135370_(SPAWNSHEARED)).booleanValue() || this.isTamed()) {
            this.setSheared(false);
        }
    }

    protected ResourceLocation m_7582_() {
        if (this.isSheared()) {
            return super.m_7582_();
        }
        return LootTableResources.WOOLED_WHITE_LOOT;
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean flag) {
        this.f_19804_.m_135381_(SHEARED, (Object)flag);
    }

    public void shear(Player player, ItemStack used) {
        LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(EntityWooly.shearedLootTable(this.m_7582_()));
        lootTable.m_79148_(this.dailyDropContext().m_78984_(LootCtxParameters.UUID_CONTEXT, (Object)player.m_142081_()).m_78984_(LootContextParams.f_81463_, (Object)used).m_78975_(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((EntityWooly)this).m_19983_(arg_0));
        this.setSheared(true);
        this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 0.84375, -0.375);
    }

    protected float attackChance() {
        return (Boolean)this.m_20088_().m_135370_(SPAWNSHEARED) != false || this.isTamed() ? 0.8f : 0.0f;
    }

    public static ResourceLocation shearedLootTable(ResourceLocation def) {
        return new ResourceLocation(def.m_135827_(), def.m_135815_() + "_sheared_drops");
    }
}

