/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityPollen;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityAmbrosia
extends BossMonster {
    public static final AnimatedAction KICK_1 = AnimatedAction.builder((double)0.6, (String)"kick_1").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction KICK_2 = AnimatedAction.builder((double)0.6, (String)"kick_2").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction KICK_3 = AnimatedAction.builder((double)0.84, (String)"kick_3").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction BUTTERFLY = AnimatedAction.builder((double)2.04, (String)"butterfly").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction WAVE = AnimatedAction.builder((double)2.24, (String)"wave").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.76, (String)"sleep").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction POLLEN = AnimatedAction.builder((double)0.72, (String)"pollen").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction POLLEN_2 = AnimatedAction.copyOf((AnimatedAction)POLLEN, (String)"pollen_2");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)2.4, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)KICK_1, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{KICK_1, BUTTERFLY, WAVE, SLEEP, POLLEN, POLLEN_2, KICK_2, KICK_3, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityAmbrosia>> ATTACK_HANDLER = EntityAmbrosia.createAnimationHandler(b -> {
        b.put((Object)BUTTERFLY, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BUTTERFLY.get())))).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimatedAction, EntityAmbrosia> kick = (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            if (target != null) {
                entity.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::m_7327_);
            }
        };
        b.put((Object)KICK_1, kick);
        b.put((Object)KICK_2, kick);
        b.put((Object)KICK_3, kick);
        b.put((Object)SLEEP, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.SLEEP_BALLS.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)WAVE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WAVE.get())))).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimatedAction, EntityAmbrosia> pollenHandler = (anim, entity) -> {
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.35));
            }
            entity.m_20256_(entity.moveDirection);
            if (anim.isAt("attack") && !EntityUtils.sealed((LivingEntity)entity)) {
                entity.m_21573_().m_26573_();
                EntityPollen pollen = new EntityPollen(entity.f_19853_, (LivingEntity)entity);
                pollen.m_6034_(pollen.m_20185_(), pollen.m_20186_() + 0.5, pollen.m_20189_());
                entity.f_19853_.m_7967_((Entity)pollen);
            }
        };
        b.put((Object)POLLEN, pollenHandler);
        b.put((Object)POLLEN_2, pollenHandler);
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityAmbrosia>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(BUTTERFLY).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.5, 1.1, 6), e -> 40 + e.m_21187_().nextInt(10))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(KICK_1).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 50 + e.m_21187_().nextInt(10))), (int)11), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(SLEEP).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.2, 2.0), e -> 50 + e.m_21187_().nextInt(10))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WAVE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 1.5), e -> 20 + e.m_21187_().nextInt(10))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(POLLEN).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 2.0), e -> 45 + e.m_21187_().nextInt(10))), (int)9));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityAmbrosia>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(7.0f, 5.0f, 1.0f, 0.2f)), (int)1));
    public final AnimatedAttackGoal<EntityAmbrosia> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityAmbrosia> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.f_19853_.f_46443_ && anim == null) {
            AnimatedAction chainAnim;
            boolean chain = !this.commanded;
            this.setMoveDirection(null);
            this.commanded = false;
            if (chain && (chainAnim = this.chainAnim(this.getAnimationHandler().getAnimation())) != null) {
                this.getAnimationHandler().setAnimation(chainAnim);
                return true;
            }
        }
        return false;
    });
    private boolean commanded;
    private Vec3 moveDirection;

    public EntityAmbrosia(EntityType<? extends EntityAmbrosia> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.AMBROSIA_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.29);
        super.applyAttributes();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{WAVE, ANGRY})) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{POLLEN, ANGRY, DEFEAT})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public boolean shouldFreezeTravel() {
        return this.getAnimationHandler().isCurrent(new AnimatedAction[]{WAVE});
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{POLLEN, POLLEN_2})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BUTTERFLY}) && this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            this.setTargetPosition(new MobAttackExt.TargetPosition(target.m_20182_(), target.m_20186_(), target.m_20186_() + (double)target.m_20206_() * 0.3));
        } else {
            super.setupAttack(anim);
        }
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{POLLEN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow + 2.0, grow, grow + 2.0), this.m_146908_(), this.m_146909_(), this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.6;
        double length = (double)this.m_20205_() * 2.1;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.WAVE.get()))) {
                    this.getAnimationHandler().setAnimation(WAVE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.SLEEP_BALLS.get()))) {
                    this.getAnimationHandler().setAnimation(SLEEP);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                this.getAnimationHandler().setAnimation(KICK_1);
            }
            this.commanded = true;
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.8125, -0.3125);
    }

    public AnimationHandler<EntityAmbrosia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (prev.equals(POLLEN_2.getID())) {
            return !POLLEN.is(new AnimatedAction[]{other});
        }
        if (prev.equals(KICK_3.getID())) {
            return !KICK_1.is(new AnimatedAction[]{other});
        }
        return super.allowAnimation(prev, other);
    }

    public AnimatedAction chainAnim(AnimatedAction anim) {
        if (anim == null) {
            return null;
        }
        return switch (anim.getID()) {
            case "kick_1" -> KICK_2;
            case "kick_2" -> KICK_3;
            case "pollen" -> POLLEN_2;
            default -> null;
        };
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    protected void setMoveDirection(Vec3 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }
}

