/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityChimera
extends BossMonster {
    public static final AnimatedAction LEAP = AnimatedAction.builder((double)1.36, (String)"leap").marker("attack_start", new double[]{0.0}).marker("attack_end", new double[]{1.2}).build();
    public static final AnimatedAction FIRE_TAIL_BUBBLE = AnimatedAction.builder((double)1.48, (String)"tail_beam").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction WATER_TAIL_BUBBLE = AnimatedAction.copyOf((AnimatedAction)FIRE_TAIL_BUBBLE, (String)"water_tail_bubble");
    public static final AnimatedAction WATER_TAIL_BEAM = AnimatedAction.copyOf((AnimatedAction)FIRE_TAIL_BUBBLE, (String)"water_tail_beam");
    public static final AnimatedAction FIRE_BREATH = AnimatedAction.builder((double)1.2, (String)"breath_attack").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction BUBBLE_BEAM = AnimatedAction.copyOf((AnimatedAction)FIRE_BREATH, (String)"bubble_beam");
    public static final AnimatedAction SLASH = AnimatedAction.builder((double)0.64, (String)"claw_attack").marker("attack", new double[]{0.36, 0.72}).build();
    public static final AnimatedAction BITE = AnimatedAction.builder((double)1.04, (String)"bite_attack").marker("attack_1", new double[]{0.4}).marker("attack_2", new double[]{0.72}).build();
    public static final AnimatedAction ANGRY = new AnimatedAction(1.04, "angry");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SLASH, (String)"interact");
    private static final AnimatedAction[] ANIMATED_ACTIONS = new AnimatedAction[]{LEAP, FIRE_TAIL_BUBBLE, WATER_TAIL_BUBBLE, WATER_TAIL_BEAM, FIRE_BREATH, BUBBLE_BEAM, SLASH, BITE, DEFEAT, INTERACT, ANGRY, SLEEP};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityChimera>> ATTACK_HANDLER = EntityChimera.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityChimera> summonFire = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIREBALL_BARRAGE.get())))).use((LivingEntity)entity);
            }
        };
        b.put((Object)FIRE_TAIL_BUBBLE, summonFire);
        b.put((Object)FIRE_BREATH, summonFire);
        BiConsumer<AnimatedAction, EntityChimera> summonWater = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BUBBLE_BEAM.get())))).use((LivingEntity)entity);
            }
        };
        b.put((Object)BUBBLE_BEAM, summonWater);
        b.put((Object)WATER_TAIL_BUBBLE, summonWater);
        b.put((Object)WATER_TAIL_BEAM, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_LASER.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)LEAP, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<LivingEntity>();
                }
                if (entity.chargeMotion == null) {
                    Vec3 dir = EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.4);
                    entity.setChargeMotion(new Vec3(dir.f_82479_, 0.0, dir.f_82481_));
                }
                entity.m_20334_(entity.chargeMotion.f_82479_, entity.m_20184_().f_82480_, entity.chargeMotion.f_82481_);
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.UP))) {
                        entity.chargeAttackSuccess = true;
                        entity.hitEntity.add((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.SLASH.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)BITE, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(5).knockAmount(0.0f)));
            } else if (anim.isAt("attack_2")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityChimera>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(LEAP).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 30 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_TAIL_BUBBLE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WATER_TAIL_BUBBLE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WATER_TAIL_BEAM).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_BREATH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(BUBBLE_BEAM).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(SLASH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 30 + e.m_21187_().nextInt(15))), (int)10));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityChimera>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.1, 1.0)), (int)9), WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveAwayRunner(4.0, 1.0, 6)), (int)10));
    public final AnimatedAttackGoal<EntityChimera> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityChimera> animationHandler = new AnimationHandler((Entity)this, ANIMATED_ACTIONS).withChangeListener(anim -> {
        if (!this.f_19853_.f_46443_) {
            if (anim == null) {
                this.setChargeMotion(null);
            }
            if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
                this.hitEntity = null;
                if (this.chargeAttackSuccess) {
                    this.chargeAttackSuccess = false;
                    this.getAnimationHandler().setAnimation(BITE);
                    return true;
                }
            }
            return false;
        }
        return false;
    });
    protected boolean chargeAttackSuccess;
    private Vec3 chargeMotion;
    protected List<LivingEntity> hitEntity;

    public EntityChimera(EntityType<? extends EntityChimera> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
        this.f_19793_ = 1.0f;
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.CHIMERA_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.31);
        super.applyAttributes();
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{DEFEAT, ANGRY})) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT, LEAP})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.6;
        double length = (double)this.m_20205_() * 1.7;
        if (anim.is(new AnimatedAction[]{BITE})) {
            width = (double)this.m_20205_() * 1.2;
            length = (double)this.m_20205_() * 1.3;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        Vec3 dir;
        float offset;
        if (anim.is(new AnimatedAction[]{LEAP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(0.3, 0.1, 0.3 + this.m_20184_().m_82490_(0.3).m_82553_()), this.m_146908_(), 0.0f, this.m_20182_());
        }
        if (!anim.is(new AnimatedAction[]{BITE})) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double reach = (double)this.m_20205_() * 0.9;
        float f = offset = anim.isAt("attack") ? 45.0f : -5.0f;
        if (target != null && !this.m_5807_()) {
            reach = Math.min(reach, this.m_20182_().m_82554_(target));
            dir = MathUtils.rotate((Vec3)MathUtils.NORMAL_Y, (Vec3)target.m_82546_(this.m_20182_()).m_82541_(), (float)(offset * ((float)Math.PI / 180)));
        } else {
            Entity entity = this.m_6688_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                dir = Vec3.m_82498_((float)player.m_146909_(), (float)(player.m_146908_() + offset));
            } else {
                dir = Vec3.m_82498_((float)this.m_146909_(), (float)(this.m_146908_() + offset));
            }
        }
        Vec3 attackPos = this.m_20182_().m_82549_(dir.m_82490_(reach));
        return new OrientedBoundingBox(this.attackBB(anim).m_82377_(grow, 0.0, grow), this.m_146908_() + 45.0f, 0.0f, attackPos);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.BUBBLE_BEAM.get()))) {
                    this.getAnimationHandler().setAnimation(BUBBLE_BEAM);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.SLASH.get()))) {
                    this.getAnimationHandler().setAnimation(SLASH);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                this.getAnimationHandler().setAnimation(LEAP);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_CHIMERA_AMBIENT.get();
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
            return this.chargeMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.421875, -0.3125);
    }

    public void setChargeMotion(Vec3 charge) {
        this.chargeMotion = charge;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    public AnimationHandler<EntityChimera> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.chargeMotion = motion;
        });
    }
}

