/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.spells.HealT1Spell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityDeadTree
extends BossMonster {
    private static final EntityDataAccessor<Byte> SUMMON_ANIMATION = SynchedEntityData.m_135353_(EntityDeadTree.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)0.92, (String)"attack").marker("attack", new double[]{0.44, 0.68}).build();
    public static final AnimatedAction FALLING_APPLES = AnimatedAction.builder((double)0.72, (String)"falling_apples").marker("attack", new double[]{0.36}).withClientID("summon").build();
    public static final AnimatedAction APPLE_SHIELD = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"apple_shield");
    public static final AnimatedAction SPIKE = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"spike");
    public static final AnimatedAction BIG_FALLING_APPLES = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"big_falling_apples");
    public static final AnimatedAction MORE_FALLING_APPLES = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"more_falling_apples");
    public static final AnimatedAction HEAL = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"heal");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)1.24, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)ATTACK, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{ATTACK, FALLING_APPLES, APPLE_SHIELD, SPIKE, BIG_FALLING_APPLES, MORE_FALLING_APPLES, HEAL, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityDeadTree>> ATTACK_HANDLER = EntityDeadTree.createAnimationHandler(b -> {
        b.put((Object)ATTACK, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        });
        b.put((Object)FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_RAIN.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)APPLE_SHIELD, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_SHIELD.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)BIG_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_RAIN_BIG.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)MORE_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_RAIN_MORE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)SPIKE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ROOT_SPIKE_TRIPLE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)HEAL, (anim, entity) -> {
            if (anim.isAt("attack")) {
                float healAmount = (float)(CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.MAGIC.get()) * 2.0);
                entity.m_5634_(healAmount);
                ServerLevel serverLevel = (ServerLevel)entity.f_19853_;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() + 0.5, entity.m_20189_(), 0, 0.0, 0.1, 0.0, 0.0);
                HealT1Spell.spawnHealParticles((LivingEntity)entity);
                HealT1Spell.spawnHealParticles((LivingEntity)entity);
                HealT1Spell.spawnHealParticles((LivingEntity)entity);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityDeadTree>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(ATTACK).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 35 + e.m_21187_().nextInt(15))), (int)9), WeightedEntry.m_146290_((Object)new GoalAttackAction(FALLING_APPLES).cooldown(e -> e.animationCooldown(FALLING_APPLES)).withCondition((goal, target, previous) -> !((EntityDeadTree)goal.attacker).isEnraged()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 4.0), e -> 35 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)new GoalAttackAction(APPLE_SHIELD).cooldown(e -> e.animationCooldown(APPLE_SHIELD)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).shieldCooldown <= 0).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(SPIKE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)9), WeightedEntry.m_146290_((Object)new GoalAttackAction(BIG_FALLING_APPLES).cooldown(e -> e.animationCooldown(BIG_FALLING_APPLES)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).isEnraged()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.m_21187_().nextInt(20))), (int)9), WeightedEntry.m_146290_((Object)new GoalAttackAction(MORE_FALLING_APPLES).cooldown(e -> e.animationCooldown(MORE_FALLING_APPLES)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).isEnraged()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)new GoalAttackAction(HEAL).cooldown(e -> e.animationCooldown(HEAL)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).healCooldown <= 0).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)11));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityDeadTree>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 3.0)), (int)1));
    public final AnimatedAttackGoal<EntityDeadTree> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityDeadTree> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.f_19853_.f_46443_ && anim != null) {
            if (anim.is(new AnimatedAction[]{APPLE_SHIELD})) {
                this.shieldCooldown = 100;
            }
            if (anim.is(new AnimatedAction[]{HEAL})) {
                this.healCooldown = 100;
            }
        } else if (anim != null && anim.getClientIdentifier().equals("summon")) {
            int rand = this.f_19796_.nextInt(3);
            AnimatedAction animNew = AnimatedAction.builder((double)anim.getLength(), (String)anim.getID()).withClientID(anim.getClientIdentifier() + "_" + rand).withTransitionTime(anim.getStartTransition(), anim.getEndTransitionTime()).speed(anim.getSpeed()).build();
            this.getAnimationHandler().setAnimation(animNew);
            return true;
        }
        return false;
    });
    private int shieldCooldown;
    private int healCooldown;

    public EntityDeadTree(EntityType<? extends EntityDeadTree> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.DEAD_TREE_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        super.applyAttributes();
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level){

            @Nullable
            protected Path m_148222_(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                if (!EntityDeadTree.this.canMove()) {
                    return null;
                }
                return super.m_148222_(targets, regionOffset, offsetUpward, accuracy, followRange);
            }
        };
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMON_ANIMATION, (Object)0);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.25f;
    }

    public byte summonAnimationType() {
        return (Byte)this.f_19804_.m_135370_(SUMMON_ANIMATION);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.shieldCooldown;
            --this.healCooldown;
        }
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim != null && anim.is(new AnimatedAction[]{SPIKE})) {
            cooldown += 40;
        }
        return cooldown;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY})) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT})) {
            return;
        }
        if (!this.canMove()) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 2.1;
        double length = (double)this.m_20205_() * 1.85;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        this.m_21573_().m_26573_();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.ROOT_SPIKE_TRIPLE.get()))) {
                    this.getAnimationHandler().setAnimation(SPIKE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.APPLE_RAIN.get()))) {
                    this.getAnimationHandler().setAnimation(FALLING_APPLES);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12599_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENTITY_DEAD_TREE_DEATH.get();
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 3.5625, -0.1875).m_82490_(2.0);
    }

    public AnimationHandler<EntityDeadTree> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return DEFEAT;
    }

    public boolean canMove() {
        return this.isTamed() || this.isEnraged();
    }
}

