/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityGrimoire
extends BossMonster {
    private static final List<Vector3f> CIRCLE_PARTICLE_MOTION = RayTraceUtils.rotatedVecs((Vec3)new Vec3(0.25, 0.0, 0.0), (Vec3)new Vec3(0.0, 1.0, 0.0), (float)-180.0f, (float)175.0f, (float)5.0f);
    public static final AnimatedAction TAIL_SWIPE = AnimatedAction.builder((double)0.84, (String)"tail_swipe").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction BITE = AnimatedAction.builder((double)0.8, (String)"bite").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction GUST = AnimatedAction.builder((double)1.96, (String)"gust").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.72, (String)"charge").infinite().marker("charge_start", new double[]{0.16}).marker("charge_end", new double[]{1.6}).build();
    public static final AnimatedAction CHARGE_LAND = AnimatedAction.builder((double)0.48, (String)"charge_land").marker("attack", new double[]{0.16}).build();
    public static final AnimatedAction WIND_BREATH = AnimatedAction.builder((double)1.36, (String)"wind_breath").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction TORNADO = AnimatedAction.builder((double)1.24, (String)"tornado").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = new AnimatedAction(1.44, "angry");
    public static final AnimatedAction SLEEP = new AnimatedAction(0.0, "sleep");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)TAIL_SWIPE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{TAIL_SWIPE, BITE, GUST, CHARGE, CHARGE_LAND, WIND_BREATH, TORNADO, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityGrimoire>> ATTACK_HANDLER = EntityGrimoire.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityGrimoire> melee = (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        };
        b.put((Object)TAIL_SWIPE, melee);
        b.put((Object)BITE, melee);
        b.put((Object)GUST, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.GUST_ROCKS.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)WIND_BREATH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WIND_BLADE_BARRAGE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)TORNADO, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.TORNADO.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("charge_start") && !anim.isPast("charge_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<LivingEntity>();
                }
                if (entity.moveDirection == null) {
                    entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.35));
                }
                entity.m_20256_(entity.moveDirection);
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f))) {
                        entity.hitEntity.add((LivingEntity)e);
                    }
                });
            }
            if (anim.isPast("charge_end")) {
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, -0.06, 0.0));
                if (entity.m_20184_().f_82480_ < -0.72) {
                    entity.m_20334_(entity.m_20184_().f_82479_, -0.72, entity.m_20184_().f_82481_);
                }
                if (entity.m_20096_()) {
                    entity.getAnimationHandler().setAnimation(CHARGE_LAND);
                }
                if (!(!anim.isPast(6.0) || entity.m_146900_().m_60713_(Blocks.f_50016_) && entity.m_20075_().m_60713_(Blocks.f_50016_))) {
                    entity.getAnimationHandler().setAnimation(CHARGE_LAND);
                }
            }
        });
        b.put((Object)CHARGE_LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                CustomDamage.Builder source = new CustomDamage.Builder((Entity)entity).noKnockback().element(EnumElement.WIND).hurtResistant(5);
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, source));
                S2CScreenShake.sendAround((Entity)entity, 24.0, 4, 3.0f);
                entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_11913_, entity.m_5720_(), 1.0f, 0.9f);
                entity.f_19853_.m_7605_((Entity)entity, (byte)66);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityGrimoire>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(TAIL_SWIPE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 40 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(BITE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 40 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(GUST).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.0, 1.0, 7), e -> 40 + e.m_21187_().nextInt(15))), (int)9), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(CHARGE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 6.0), e -> 40 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WIND_BREATH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.0, 1.0, 6), e -> 40 + e.m_21187_().nextInt(20))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(TORNADO).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 6), e -> 40 + e.m_21187_().nextInt(15))), (int)10));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityGrimoire>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 1.5)), (int)1));
    public final AnimatedAttackGoal<EntityGrimoire> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGrimoire> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (CHARGE.is(new AnimatedAction[]{anim})) {
            this.hitEntity = null;
        }
        if (!this.f_19853_.f_46443_ && anim == null) {
            boolean chain = !this.commanded;
            this.setMoveDirection(null);
            this.commanded = false;
            if (chain && this.isEnraged() && this.getAnimationHandler().isCurrent(new AnimatedAction[]{BITE})) {
                this.getAnimationHandler().setAnimation(TAIL_SWIPE);
                return true;
            }
        }
        return false;
    });
    private boolean commanded;
    protected List<LivingEntity> hitEntity;
    private Vec3 moveDirection;

    public EntityGrimoire(EntityType<? extends EntityGrimoire> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.GRIMOIRE_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.29);
        super.applyAttributes();
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY}) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT, CHARGE})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE, CHARGE_LAND})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    @Override
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 66) {
            for (Vector3f vec : CIRCLE_PARTICLE_MOTION) {
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.WIND.get(), 0.2627451f, 0.6392157f, 0.25490198f, 1.0f, 0.4f), this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), (double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_());
            }
        }
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{CHARGE_LAND})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(1.2, 0.1, 1.2), this.m_146908_(), 0.0f, this.m_20182_());
        }
        if (anim.is(new AnimatedAction[]{CHARGE})) {
            double width = this.m_20205_();
            double speed = Math.max(width, this.m_20184_().m_82553_() - width);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow + 0.5, 0.1, grow + 0.5).m_82363_(0.0, 0.0, speed), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 1.5;
        if (anim.is(new AnimatedAction[]{TAIL_SWIPE})) {
            width = (double)this.m_20205_() * 1.5;
            length = (double)this.m_20205_() * 1.45;
            return new AABB(-width * 0.65, -0.02, 0.0, width * 0.35, (double)this.m_20206_() + 0.02, length);
        }
        if (anim.is(new AnimatedAction[]{BITE})) {
            width = (double)this.m_20205_() * 1.1;
            length = (double)this.m_20205_() * 1.4;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.WIND_BLADE_BARRAGE.get()))) {
                    this.getAnimationHandler().setAnimation(WIND_BREATH);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                    this.getAnimationHandler().setAnimation(TAIL_SWIPE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                this.getAnimationHandler().setAnimation(BITE);
            }
            this.commanded = true;
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 2.4375, 0.71875).m_82490_(1.5);
    }

    public AnimationHandler<EntityGrimoire> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (prev.equals(BITE.getID())) {
            return !this.isEnraged() || !TAIL_SWIPE.is(new AnimatedAction[]{other});
        }
        return super.allowAnimation(prev, other);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    protected void setMoveDirection(Vec3 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }
}

