/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityHandonetta
extends BossMonster {
    public static final AnimatedAction SWIPE = AnimatedAction.builder((double)1.28, (String)"swipe").marker("attack", new double[]{0.64}).build();
    public static final AnimatedAction FLICK = AnimatedAction.builder((double)1.32, (String)"flick").marker("attack", new double[]{0.64}).build();
    public static final AnimatedAction SHOOT = AnimatedAction.builder((double)1.44, (String)"shoot").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction LASER = AnimatedAction.builder((double)1.24, (String)"laser").marker("aim", new double[]{0.3}).marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction PLATE = AnimatedAction.builder((double)0.88, (String)"plate").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction GRAB = AnimatedAction.builder((double)1.2, (String)"grab").marker("attack", new double[]{0.56}).marker("invis_start", new double[]{0.72}).marker("grab_done", new double[]{1.04}).build();
    public static final AnimatedAction GRAB_CAUGHT = AnimatedAction.builder((double)1.96, (String)"grab_caught").marker("attack", new double[]{0.12, 0.6, 1.04, 1.48}).marker("attack_end", new double[]{1.8}).build();
    public static final AnimatedAction PUNCH = AnimatedAction.builder((double)1.2, (String)"punch").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.04}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)1.56, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWIPE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SWIPE, FLICK, SHOOT, LASER, PLATE, GRAB, GRAB_CAUGHT, PUNCH, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityHandonetta>> ATTACK_HANDLER = EntityHandonetta.createAnimationHandler(b -> {
        b.put((Object)SWIPE, (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::m_7327_);
            }
        });
        b.put((Object)FLICK, (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::m_7327_);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET).m_82490_(0.75));
                entity.caughtEntities.clear();
            }
            entity.m_20256_(entity.moveDirection);
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.caughtEntities.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(8))) {
                        entity.caughtEntities.add((LivingEntity)e);
                        S2CScreenShake.sendAround((Entity)entity, 32.0, 4, 2.0f);
                    }
                });
            }
        });
        b.put((Object)SHOOT, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DARK_BULLETS.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)LASER, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (entity.m_5448_() != null && !anim.isPast("aim")) {
                entity.setTargetPosition(entity.m_5448_());
            }
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DARK_BEAM.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)PLATE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PLATE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)GRAB, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET).m_82490_(0.45));
            }
            entity.m_20256_(entity.moveDirection);
            if (anim.isPast("grab_done")) {
                if (!entity.caughtEntities.isEmpty()) {
                    entity.getAnimationHandler().setAnimation(GRAB_CAUGHT);
                }
            } else if (anim.isPast("attack") && !anim.isPast("grab_done")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.caughtEntities.contains(e)) {
                        entity.catchEntity((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)GRAB_CAUGHT, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            entity.m_20256_(entity.m_20184_().m_82490_(0.1));
            if (anim.isAt("attack")) {
                entity.caughtEntities.forEach(entity::m_7327_);
                S2CScreenShake.sendAround((Entity)entity, 24.0, 4, 1.0f);
            }
            if (anim.isPast("attack_end") && !entity.caughtEntities.isEmpty()) {
                entity.caughtEntities.forEach(e -> e.m_21195_((MobEffect)ModEffects.TRUE_INVIS.get()));
                entity.caughtEntities.clear();
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityHandonetta>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(SWIPE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 70 + e.m_21187_().nextInt(50))).withCondition((goal, target, previous) -> ((EntityHandonetta)goal.attacker).allowAnimation(previous, SWIPE) && (goal.distanceToTargetSq < 16.0 || (double)((EntityHandonetta)goal.attacker).f_19796_.nextFloat() < 0.5)), (int)11), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FLICK).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 70 + e.m_21187_().nextInt(50))).withCondition((goal, target, previous) -> ((EntityHandonetta)goal.attacker).allowAnimation(previous, FLICK) && (goal.distanceToTargetSq < 16.0 || (double)((EntityHandonetta)goal.attacker).f_19796_.nextFloat() < 0.5)), (int)11), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(PUNCH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 8.0, true, true, true), e -> 70 + e.m_21187_().nextInt(50))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(LASER).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(7.0, 9.0, 1.0), e -> 70 + e.m_21187_().nextInt(50))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(PLATE).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(7.0, 11.0, 1.0), e -> 70 + e.m_21187_().nextInt(50))), (int)9), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(GRAB).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 5.0, true, true, true), e -> 70 + e.m_21187_().nextInt(50))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(SHOOT).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(7.0, 10.0, 1.0), e -> 70 + e.m_21187_().nextInt(50))), (int)9));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityHandonetta>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(10.0f, 8.0f, 0.8f, 0.1f)), (int)2));
    public final AnimatedAttackGoal<EntityHandonetta> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityHandonetta> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.moveDirection = null;
        if (anim != null) {
            this.m_20256_(this.m_20184_().m_82490_(0.1));
        }
        return false;
    });
    private final List<LivingEntity> caughtEntities = new ArrayList<LivingEntity>();
    private Vec3 moveDirection;

    public EntityHandonetta(EntityType<? extends EntityHandonetta> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
        this.m_20242_(true);
        this.f_21342_ = new HandonettaMoveController((Mob)this);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.HANDONETTA_FIGHT.get());
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        super.m_7840_(y, false, state, pos);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.26);
        this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        this.m_21051_(Attributes.f_22280_).m_22100_(0.32);
    }

    @Override
    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<Player>((Mob)this, Player.class, 16, true, true, player -> !this.isTamed());
    }

    @Override
    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestTargetHorizontal<Mob>((Mob)this, Mob.class, 16, true, true, this.targetPred);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB, GRAB_CAUGHT}) && this.caughtEntities.contains(source.m_7639_())) {
            return false;
        }
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY})) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{PUNCH, GRAB})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder builder = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SWIPE})) {
            builder.knock(CustomDamage.KnockBackType.BACK);
            builder.knockAmount(1.2f);
        }
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{FLICK})) {
            builder.knock(CustomDamage.KnockBackType.UP);
            builder.knockAmount(0.9f);
        }
        return builder;
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{PUNCH})) {
            float[] rots = MathsHelper.YXRotFrom(this.moveDirection);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow + 0.2, grow, grow + 0.2), rots[0], rots[1], this.m_20182_());
        }
        if (anim.is(new AnimatedAction[]{GRAB})) {
            float[] rots = MathsHelper.YXRotFrom(this.moveDirection);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow, 0.0, grow), rots[0], rots[1], this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow).inflate(0.0, grow * 2.0, 0.0);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 2.2;
        double length = (double)this.m_20205_() * 1.7;
        if (anim.is(new AnimatedAction[]{FLICK})) {
            width = (double)this.m_20205_() * 1.6;
            length = (double)this.m_20205_() * 1.8;
        }
        return new AABB(-width * 0.5, -0.5, 0.0, width * 0.5, (double)this.m_20206_() + 0.5, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.DARK_BULLETS.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(FLICK);
            } else {
                this.getAnimationHandler().setAnimation(SWIPE);
            }
        }
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB, GRAB_CAUGHT})) {
            boolean invis = this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB}) ? this.getAnimationHandler().getAnimation().isPast("invis_start") : this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB_CAUGHT});
            this.caughtEntities.forEach(e -> {
                if (e.m_6084_()) {
                    if (e instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)e;
                        player.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    } else {
                        e.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    }
                    if (invis) {
                        e.m_7292_(new MobEffectInstance((MobEffect)ModEffects.TRUE_INVIS.get(), 10, 1, true, false, false));
                    }
                }
            });
        }
    }

    private void catchEntity(LivingEntity entity) {
        this.caughtEntities.add(entity);
    }

    public void m_7334_(Entity entityIn) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{PUNCH, GRAB})) {
            return;
        }
        super.m_7334_(entityIn);
    }

    public boolean m_20096_() {
        return super.m_20096_();
    }

    @Override
    public void m_7023_(Vec3 vec) {
        this.handleFreeTravel(vec);
    }

    public AnimationHandler<EntityHandonetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.453125, -0.375);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    protected void setMoveDirection(Vec3 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }

    static class HandonettaMoveController
    extends FreeMoveControl {
        public HandonettaMoveController(Mob mob) {
            super(mob);
        }

        @Override
        public void m_8126_() {
            MoveControl.Operation current = this.f_24981_;
            super.m_8126_();
            if (current == MoveControl.Operation.STRAFE && this.f_24974_.m_5448_() != null) {
                Vec3 target = this.f_24974_.m_5448_().m_20182_();
                Vec3 dist = this.f_24974_.m_20182_().m_82546_(target);
                if (dist.m_7098_() < 4.0) {
                    this.f_24974_.m_21567_(1.0f);
                } else {
                    this.f_24974_.m_21567_(-1.0f);
                }
                if (dist.m_165925_() < 16.0) {
                    this.f_24974_.m_7910_(this.f_24974_.m_6113_() * 2.0f);
                    this.f_24974_.m_21564_(-1.0f);
                    this.f_24974_.m_21570_(this.f_24974_.f_20900_ * 0.5f);
                }
            }
        }
    }
}

