/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMarionettaTrap;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.JumpEvadeAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMarionetta
extends BossMonster {
    private static final EntityDataAccessor<Boolean> CAUGHT = SynchedEntityData.m_135353_(EntityMarionetta.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.48, (String)"melee").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)1.52, (String)"spin").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.4}).build();
    public static final AnimatedAction CARD_ATTACK = AnimatedAction.builder((double)0.64, (String)"card_attack").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction CHEST_ATTACK = AnimatedAction.builder((double)1.2, (String)"chest_attack").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.0}).build();
    public static final AnimatedAction CHEST_THROW = AnimatedAction.builder((double)5.0, (String)"chest_throw").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction STUFFED_ANIMALS = AnimatedAction.builder((double)0.76, (String)"stuffed_animals").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction DARK_BEAM = AnimatedAction.builder((double)0.8, (String)"dark_beam").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction FURNITURE = AnimatedAction.builder((double)1.2, (String)"furniture").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)1.2, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, SPIN, CARD_ATTACK, CHEST_ATTACK, CHEST_THROW, STUFFED_ANIMALS, DARK_BEAM, FURNITURE, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityMarionetta>> ATTACK_HANDLER = EntityMarionetta.createAnimationHandler(b -> {
        b.put((Object)MELEE, (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            if (target != null) {
                entity.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::m_7327_);
            }
        });
        b.put((Object)SPIN, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.5));
            }
            entity.m_20256_(entity.moveDirection);
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(8)));
            }
        });
        b.put((Object)CARD_ATTACK, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.CARD_THROW.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)CHEST_ATTACK, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.5));
            }
            entity.m_20256_(entity.moveDirection);
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.caughtEntities.contains(e)) {
                        entity.catchEntity((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)CHEST_THROW, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                Vec3 throwVec = new Vec3(entity.m_20154_().m_7096_(), 0.0, entity.m_20154_().m_7094_()).m_82541_().m_82490_(1.2).m_82520_(0.0, 0.85, 0.0);
                EntityMarionettaTrap trap = new EntityMarionettaTrap(entity.f_19853_, (LivingEntity)entity);
                trap.setDamageMultiplier(0.9f);
                entity.caughtEntities.forEach(e -> {
                    e.m_7292_(new MobEffectInstance((MobEffect)ModEffects.TRUE_INVIS.get(), 100, 1, true, false, false));
                    trap.addCaughtEntity((LivingEntity)e);
                });
                trap.m_20256_(throwVec);
                entity.f_19853_.m_7967_((Entity)trap);
                entity.caughtEntities.clear();
            }
        });
        b.put((Object)STUFFED_ANIMALS, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PLUSH_THROW.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)DARK_BEAM, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack") && !EntityUtils.sealed((LivingEntity)entity)) {
                ((Spell)((Object)((Object)((Object)ModSpells.DARK_BEAM.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)FURNITURE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack") && !EntityUtils.sealed((LivingEntity)entity)) {
                ((Spell)((Object)((Object)((Object)ModSpells.FURNITURE.get())))).use((LivingEntity)entity);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityMarionetta>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(MELEE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 30 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(SPIN).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.5), e -> 35 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(CARD_ATTACK).prepare(() -> new TimedWrappedRunner((ActionRun)new JumpEvadeAction(2.0, 0.9, 0.5, 0.0f, 0.5f, (ActionRun)new DoNothingRunner(true)), e -> 5)), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(CHEST_ATTACK).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.5), e -> 35 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(STUFFED_ANIMALS).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(3.0, 7.0, 1.2), e -> 30 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(DARK_BEAM).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(FURNITURE).prepare(() -> new TimedWrappedRunner((ActionRun)new DoNothingRunner(true), e -> 5)), (int)1));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityMarionetta>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new JumpEvadeAction(2.0, 0.9, 0.5, 0.015f, 0.4f, (ActionRun)new StrafingRunner(7.0f, 1.0f))), (int)10), WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(7.0f, 1.0f)), (int)8));
    public final AnimatedAttackGoal<EntityMarionetta> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMarionetta> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.moveDirection = null;
        if (((Boolean)this.f_19804_.m_135370_(CAUGHT)).booleanValue()) {
            if (!this.f_19853_.f_46443_) {
                this.f_19804_.m_135381_(CAUGHT, (Object)false);
                this.getAnimationHandler().setAnimation(CHEST_THROW);
            }
            return true;
        }
        return false;
    });
    private final List<LivingEntity> caughtEntities = new ArrayList<LivingEntity>();
    private Vec3 moveDirection;

    public EntityMarionetta(EntityType<? extends EntityMarionetta> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.MARIONETTA_FIGHT.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAUGHT, (Object)false);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    public boolean caughtTarget() {
        return (Boolean)this.f_19804_.m_135370_(CAUGHT);
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.26);
        super.applyAttributes();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.caughtEntities.contains(source.m_7639_())) {
            return false;
        }
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHEST_THROW, ANGRY})) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SPIN, CHEST_ATTACK})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            float rotY = -Mth.m_14177_((float)((float)(Mth.m_14136_((double)this.moveDirection.m_7096_(), (double)this.moveDirection.m_7094_()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow + 1.6, 0.1, grow + 1.6), rotY, 0.0f, this.m_20182_());
        }
        if (anim.is(new AnimatedAction[]{CHEST_ATTACK})) {
            float rotY = -Mth.m_14177_((float)((float)(Mth.m_14136_((double)this.moveDirection.m_7096_(), (double)this.moveDirection.m_7094_()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow + 1.2, 0.1, grow + 1.2), rotY, 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.5;
        double length = (double)this.m_20205_() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.CARD_THROW.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CARD_ATTACK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.caughtEntities.forEach(e -> {
            if (e.m_6084_()) {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_6027_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 0.2, this.m_20189_());
                } else {
                    e.m_6034_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 0.2, this.m_20189_());
                }
            }
        });
    }

    private void catchEntity(LivingEntity entity) {
        this.caughtEntities.add(entity);
        this.f_19804_.m_135381_(CAUGHT, (Object)true);
    }

    public void m_7334_(Entity entityIn) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SPIN, CHEST_ATTACK})) {
            return;
        }
        super.m_7334_(entityIn);
    }

    public AnimationHandler<EntityMarionetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.078125, -0.375);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    protected void setMoveDirection(Vec3 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }
}

