/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.misc.GroundShakeParticleSpawner;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.CustomDataSerializers;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityRaccoon
extends BossMonster {
    public static final Vec3[] CLONE_POS = new Vec3[]{new Vec3(-4.0, 0.0, 0.0), new Vec3(0.0, 0.0, -4.0), new Vec3(4.0, 0.0, 0.0), new Vec3(0.0, 0.0, 4.0)};
    private static final EntityDataAccessor<Boolean> BERSERK = SynchedEntityData.m_135353_(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<Vec3>> CLONE_CENTER = SynchedEntityData.m_135353_(EntityRaccoon.class, (EntityDataSerializer)CustomDataSerializers.OPTIONAL_VEC);
    private static final EntityDataAccessor<Integer> CLONE_INDEX = SynchedEntityData.m_135353_(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final AnimatedAction DOUBLE_PUNCH = AnimatedAction.builder((double)0.88, (String)"double_punch").marker("attack", new double[]{0.4, 0.68}).build();
    public static final AnimatedAction PUNCH = AnimatedAction.builder((double)0.92, (String)"punch").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction JUMP = AnimatedAction.builder((double)1.08, (String)"jump").marker("jump", new double[]{0.2}).infinite().build();
    public static final AnimatedAction LAND = AnimatedAction.builder((double)0.4, (String)"land").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction STOMP = AnimatedAction.builder((double)1.36, (String)"stomp").marker("attack", new double[]{0.56, 1.12}).build();
    public static final AnimatedAction LEAF_SHOOT = AnimatedAction.builder((double)0.88, (String)"shoot").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction LEAF_BOOMERANG = AnimatedAction.copyOf((AnimatedAction)LEAF_SHOOT, (String)"spinning_shoot");
    public static final AnimatedAction LEAF_SHOT_CLONE = AnimatedAction.builder((double)0.88, (String)"leaf_clone").withClientID("shoot").marker("attack", new double[]{0.44, 0.64}).build();
    public static final AnimatedAction BARRAGE = AnimatedAction.builder((double)3.32, (String)"punch_barrage").marker("attack", new double[]{0.44, 0.84, 1.28}).marker("vulnerable_start", new double[]{1.52}).marker("vulnerable_end", new double[]{3.04}).build();
    public static final AnimatedAction ROAR = AnimatedAction.builder((double)1.24, (String)"roar").marker("roar", new double[]{0.12}).build();
    public static final AnimatedAction ANGRY = AnimatedAction.copyOf((AnimatedAction)ROAR, (String)"angry");
    public static final AnimatedAction CLONE = AnimatedAction.copyOf((AnimatedAction)ROAR, (String)"clone");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction TRANSFORM = AnimatedAction.builder((double)1.5, (String)"transform").build();
    public static final AnimatedAction UNTRANSFORM = AnimatedAction.builder((double)2.2, (String)"untransform").marker("knockback_start", new double[]{1.0}).marker("knockback_end", new double[]{1.5}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)DOUBLE_PUNCH, (String)"interact");
    public static final AnimatedAction INTERACT_BERSERK = AnimatedAction.copyOf((AnimatedAction)PUNCH, (String)"interact_berserk");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DOUBLE_PUNCH, PUNCH, JUMP, LAND, STOMP, LEAF_SHOOT, LEAF_BOOMERANG, LEAF_SHOT_CLONE, BARRAGE, ROAR, ANGRY, CLONE, DEFEAT, TRANSFORM, UNTRANSFORM, INTERACT, INTERACT_BERSERK};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityRaccoon>> ATTACK_HANDLER = EntityRaccoon.createAnimationHandler(b -> {
        b.put((Object)DOUBLE_PUNCH, (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            if (target != null) {
                entity.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::m_7327_);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        });
        b.put((Object)BARRAGE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                Vec3 dir;
                LivingEntity target = entity.m_5448_();
                if (target != null) {
                    Vec3 targetPos = target.m_20182_();
                    dir = new Vec3(targetPos.f_82479_ - entity.m_20185_(), 0.0, targetPos.f_82481_ - entity.m_20189_()).m_82541_();
                    entity.setTargetPosition(target);
                } else {
                    dir = new Vec3(entity.m_20154_().m_7096_(), 0.0, entity.m_20154_().m_7094_()).m_82541_();
                }
                entity.m_20256_(entity.m_20184_().m_82549_(dir.m_82490_(0.6)));
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        });
        b.put((Object)JUMP, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            double length = anim.getLength() - 3.0f;
            if (entity.jumpDir == null) {
                Vec3 dir = entity.m_5448_() != null ? entity.m_5448_().m_20182_().m_82546_(entity.m_20182_()) : entity.m_20154_();
                dir = new Vec3(dir.m_7096_(), 0.0, dir.m_7094_()).m_82541_().m_82490_(8.0);
                entity.jumpDir = dir.m_82542_(1.0 / length, 1.0, 1.0 / length);
            }
            if (anim.isAt("jump")) {
                entity.m_20334_(entity.jumpDir.f_82479_, 2.0, entity.jumpDir.f_82481_);
            }
            if (anim.isPast("jump")) {
                entity.f_19789_ = 0.0f;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, -0.08, 0.0));
                if (entity.m_20184_().f_82480_ < -1.1) {
                    entity.m_20334_(entity.m_20184_().f_82479_, -1.1, entity.m_20184_().f_82481_);
                }
                if (anim.done(0) && entity.m_20096_()) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
                if (!(!anim.isPast(6.0) || entity.m_146900_().m_60713_(Blocks.f_50016_) && entity.m_20075_().m_60713_(Blocks.f_50016_))) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
            }
        });
        b.put((Object)LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                CustomDamage.Builder source = new CustomDamage.Builder((Entity)entity).noKnockback().element(EnumElement.EARTH).hurtResistant(5).withChangedAttribute((Attribute)ModAttributes.STUN.get(), 80.0);
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, source));
                S2CScreenShake.sendAround((Entity)entity, 24.0, 8, 3.0f);
                entity.f_19853_.m_7967_((Entity)new GroundShakeParticleSpawner(entity.f_19853_, (LivingEntity)entity, 360.0, (double)entity.m_20205_() * 1.8));
                entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_11913_, entity.m_5720_(), 1.0f, 0.9f);
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                CustomDamage.Builder source = new CustomDamage.Builder((Entity)entity).noKnockback().element(EnumElement.EARTH).hurtResistant(5).withChangedAttribute((Attribute)ModAttributes.STUN.get(), 50.0);
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, source));
                S2CScreenShake.sendAround((Entity)entity, 24.0, 8, 3.0f);
                entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_11913_, entity.m_5720_(), 1.0f, 0.9f);
            }
        });
        b.put((Object)LEAF_SHOOT, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X7.get())))).use((LivingEntity)entity);
                } else if (entity.isTamed() || (double)entity.f_19796_.nextFloat() < 0.6) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X3.get())))).use((LivingEntity)entity);
                } else {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X5.get())))).use((LivingEntity)entity);
                }
            }
        });
        b.put((Object)LEAF_SHOT_CLONE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X7.get())))).use((LivingEntity)entity);
                } else if ((double)entity.f_19796_.nextFloat() < 0.6) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X3.get())))).use((LivingEntity)entity);
                } else {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X5.get())))).use((LivingEntity)entity);
                }
            }
        });
        b.put((Object)LEAF_BOOMERANG, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((Spell)((Object)((Object)((Object)ModSpells.BIG_LEAF_SPELL_DOUBLE.get())))).use((LivingEntity)entity);
                } else {
                    ((Spell)((Object)((Object)((Object)ModSpells.BIG_LEAF_SPELL.get())))).use((LivingEntity)entity);
                }
            }
        });
        b.put((Object)ROAR, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("roar")) {
                entity.playAngrySound();
            }
        });
        b.put((Object)CLONE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt(0.05)) {
                entity.playAngrySound();
                Vec3 center = entity.m_5448_() == null ? entity.m_20182_() : (entity.m_20280_((Entity)entity.m_5448_()) < 144.0 ? entity.m_5448_().m_20182_() : entity.m_5448_().m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82490_(12.0).m_82549_(entity.m_20182_()));
                entity.f_19804_.m_135381_(CLONE_CENTER, Optional.of(center));
                int id = entity.f_19796_.nextInt(CLONE_POS.length);
                Vec3 pos2 = CLONE_POS[id];
                entity.f_19804_.m_135381_(CLONE_INDEX, (Object)id);
                entity.m_6021_(center.m_7096_() + pos2.f_82479_, center.m_7098_() + pos2.f_82480_, center.m_7094_() + pos2.f_82481_);
            }
            ((Optional)entity.f_19804_.m_135370_(CLONE_CENTER)).ifPresent(pos -> entity.m_7618_(EntityAnchorArgument.Anchor.FEET, (Vec3)pos));
        });
        b.put((Object)UNTRANSFORM, (anim, entity) -> {
            if (entity.m_20096_() && anim.isPast("knockback_start") && !anim.isPast("knockback_end")) {
                entity.m_5997_(0.0, 0.4, 0.0);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityRaccoon>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)new GoalAttackAction(DOUBLE_PUNCH).cooldown(e -> e.animationCooldown(DOUBLE_PUNCH)).withCondition((goal, target, previous) -> !((EntityRaccoon)goal.attacker).isBerserk()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.0, 1.2, 5), e -> 20 + e.m_21187_().nextInt(10))), (int)20), WeightedEntry.m_146290_((Object)new GoalAttackAction(DOUBLE_PUNCH).cooldown(e -> e.animationCooldown(DOUBLE_PUNCH)).withCondition((goal, target, previous) -> !((EntityRaccoon)goal.attacker).isBerserk()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)17), WeightedEntry.m_146290_((Object)new GoalAttackAction(PUNCH).cooldown(e -> e.animationCooldown(PUNCH)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !PUNCH.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 25 + e.m_21187_().nextInt(10))), (int)20), WeightedEntry.m_146290_((Object)new GoalAttackAction(JUMP).cooldown(e -> e.animationCooldown(JUMP)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !JUMP.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 6.0), e -> 25 + e.m_21187_().nextInt(10))), (int)18), WeightedEntry.m_146290_((Object)new GoalAttackAction(STOMP).cooldown(e -> e.animationCooldown(STOMP)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !STOMP.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 25 + e.m_21187_().nextInt(10))), (int)18), WeightedEntry.m_146290_((Object)new GoalAttackAction(LEAF_SHOOT).cooldown(e -> e.animationCooldown(LEAF_SHOOT)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !LEAF_SHOOT.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 5), e -> 25 + e.m_21187_().nextInt(10))), (int)17), WeightedEntry.m_146290_((Object)new GoalAttackAction(LEAF_BOOMERANG).cooldown(e -> e.animationCooldown(LEAF_BOOMERANG)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !LEAF_BOOMERANG.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 5), e -> 25 + e.m_21187_().nextInt(10))), (int)18), WeightedEntry.m_146290_((Object)new GoalAttackAction(ROAR).cooldown(e -> e.animationCooldown(ROAR)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !ROAR.getID().equals(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)5), WeightedEntry.m_146290_((Object)new GoalAttackAction(BARRAGE).cooldown(e -> e.animationCooldown(BARRAGE)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !BARRAGE.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 25 + e.m_21187_().nextInt(10))), (int)1), WeightedEntry.m_146290_((Object)new GoalAttackAction(CLONE).cooldown(e -> e.animationCooldown(CLONE)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isEnraged() && !CLONE.getID().equals(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)15));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityRaccoon>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)).withCondition((goal, target) -> ((EntityRaccoon)goal.attacker).isBerserk()), (int)10), WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveAwayRunner(1.0, 1.0, 5)).withCondition((goal, target) -> !((EntityRaccoon)goal.attacker).isBerserk()), (int)11));
    public final AnimatedAttackGoal<EntityRaccoon> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private boolean clone;
    private Vec3 jumpDir;
    private int hit;
    private int hitCountdown = -1;
    private final AnimationHandler<EntityRaccoon> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (CLONE.is(new AnimatedAction[]{anim})) {
            this.clone = true;
        } else if (anim != null) {
            this.clone = false;
            this.f_19804_.m_135381_(CLONE_CENTER, Optional.empty());
        }
        this.jumpDir = null;
        if (anim == null && this.clone) {
            this.getAnimationHandler().setAnimation(this.m_21187_().nextBoolean() ? LEAF_SHOT_CLONE : LEAF_BOOMERANG);
            return true;
        }
        return false;
    });

    public EntityRaccoon(EntityType<? extends EntityRaccoon> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.RACCOON_FIGHT.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BERSERK, (Object)false);
        this.f_19804_.m_135372_(CLONE_CENTER, Optional.empty());
        this.f_19804_.m_135372_(CLONE_INDEX, (Object)0);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    public boolean isBerserk() {
        return (Boolean)this.f_19804_.m_135370_(BERSERK);
    }

    public Optional<Vec3> cloneCenter() {
        return (Optional)this.f_19804_.m_135370_(CLONE_CENTER);
    }

    public int cloneIndex() {
        return (Integer)this.f_19804_.m_135370_(CLONE_INDEX);
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.24);
        super.applyAttributes();
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.f_46443_) {
            --this.hitCountdown;
            if (this.m_6084_() && !this.isBerserk() && (this.hitCountdown == 0 || this.hit >= 5)) {
                this.setBerserk(true, false);
                this.hit = 0;
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{JUMP, LAND, DEFEAT, TRANSFORM, UNTRANSFORM, ANGRY})) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        AnimatedAction anim;
        super.m_6475_(damageSrc, damageAmount);
        if (!this.isBerserk()) {
            ++this.hit;
            this.hitCountdown = 30;
        } else if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{BARRAGE}) && (anim = this.getAnimationHandler().getAnimation()).isPast("vulnerable_start") && !anim.isPast("vulnerable_end")) {
            this.setBerserk(false, false);
            this.getAnimationHandler().setAnimation(UNTRANSFORM);
            this.m_5997_(0.0, 0.6, 0.0);
        }
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return super.m_5639_(fallDistance - 5.0f, damageMultiplier);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (BERSERK.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void setBerserk(boolean flag, boolean load) {
        this.f_19804_.m_135381_(BERSERK, (Object)flag);
        this.m_6210_();
        if (!load) {
            if (flag) {
                this.getAnimationHandler().setAnimation(TRANSFORM);
            } else {
                this.getAnimationHandler().setAnimation(UNTRANSFORM);
            }
            this.attack.m_8041_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isBerserk()) {
            return pose == Pose.SLEEPING ? f_20910_ : EntityDimensions.m_20398_((float)1.65f, (float)3.35f).m_20388_(this.m_6134_());
        }
        return super.m_6972_(pose);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{CLONE, TRANSFORM, UNTRANSFORM, ANGRY, ROAR, DEFEAT});
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBerserk(compound.m_128471_("Berserk"), true);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Berserk", this.isBerserk());
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, ROAR, DEFEAT})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        this.m_21573_().m_26573_();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{JUMP, LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), 0.0f, 0.0f, this.m_20182_());
        }
        if (anim.is(new AnimatedAction[]{STOMP})) {
            Vec3 dir;
            double reach = (double)this.m_20205_() * 0.55;
            float offset = anim.isAt("attack") ? -90.0f : 90.0f;
            Entity entity = this.m_6688_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                dir = Vec3.m_82498_((float)player.m_146909_(), (float)(player.m_146908_() + offset));
            } else {
                dir = Vec3.m_82498_((float)this.m_146909_(), (float)(this.m_146908_() + offset));
            }
            Vec3 attackPos = this.m_20182_().m_82549_(dir.m_82490_(reach));
            return new OrientedBoundingBox(this.attackBB(anim), this.m_146908_(), 0.0f, attackPos);
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{JUMP, LAND})) {
            double attackSize = (double)this.m_20205_() * 1.5;
            return new AABB(-attackSize, -0.5, -attackSize, attackSize, 2.0, attackSize);
        }
        if (anim.is(new AnimatedAction[]{STOMP})) {
            return new AABB(-1.8, -0.5, -2.2, 1.8, 2.0, 2.2);
        }
        double width = (double)this.m_20205_() * 1.4;
        double length = (double)this.m_20205_() * 1.5;
        if (anim.is(new AnimatedAction[]{DOUBLE_PUNCH})) {
            width = (double)this.m_20205_() * 1.5;
            length = (double)this.m_20205_() * 1.7;
        }
        if (anim.is(new AnimatedAction[]{PUNCH})) {
            width = (double)this.m_20205_() * 1.5;
            length = (double)this.m_20205_() * 1.6;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.SMALL_LEAF_SPELL_X3.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LEAF_SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(JUMP);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_PUNCH);
            }
        }
    }

    public void m_7334_(Entity entityIn) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ROAR, CLONE, TRANSFORM})) {
            return;
        }
        super.m_7334_(entityIn);
    }

    protected void m_6138_() {
        if (!this.getAnimationHandler().isCurrent(new AnimatedAction[]{CLONE})) {
            super.m_6138_();
        }
    }

    public AnimationHandler<EntityRaccoon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        if (this.isBerserk()) {
            return new Vec3(0.0, 1.015625, -0.65625).m_82490_(1.4);
        }
        return new Vec3(0.0, 1.0625, -0.3125);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

