/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntitySanoUno;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityUno;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.spells.FireWallSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class EntitySano
extends EntitySanoUno {
    public static final AnimatedAction FIREBALL_3X = AnimatedAction.builder((double)2.0, (String)"fireball_3x").marker("attack", new double[]{0.8, 1.0, 1.2}).build();
    public static final AnimatedAction FIREBALL_BARRAGE = AnimatedAction.builder((double)4.5, (String)"fireball_barrage").marker("single", new double[]{3.0}).marker("double", new double[]{3.8}).marker("triple", new double[]{0.8}).marker("quad", new double[]{1.2, 3.4}).build();
    public static final AnimatedAction EXPLOSION = AnimatedAction.builder((double)1.5, (String)"explosion").marker("attack", new double[]{0.8}).build();
    public static final AnimatedAction FIRE_BREATH = AnimatedAction.builder((double)2.0, (String)"fire_breath").marker("attack", new double[]{0.8, 1.2}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{FIREBALL_3X, FIREBALL_BARRAGE, EXPLOSION, FIRE_BREATH, DEFEAT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntitySano>> ATTACK_HANDLER = EntitySano.createAnimationHandler(b -> {
        b.put((Object)FIREBALL_3X, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIREBALL.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)FIREBALL_BARRAGE, (anim, entity) -> {
            if (anim.isAt("single")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIREBALL.get())))).use((LivingEntity)entity);
            }
            if (anim.isAt("double")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DOUBLE_FIRE_BALL.get())))).use((LivingEntity)entity);
            }
            if (anim.isAt("triple")) {
                ((Spell)((Object)((Object)((Object)ModSpells.TRIPLE_FIRE_BALL.get())))).use((LivingEntity)entity);
            }
            if (anim.isAt("quad")) {
                ((Spell)((Object)((Object)((Object)ModSpells.QUAD_FIRE_BALL.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)EXPLOSION, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EXPLOSION.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)FIRE_BREATH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                Vec3 from = FireWallSpell.offset((LivingEntity)entity);
                Vec3 dir = entity.m_5448_() != null ? EntityUtils.getStraightProjectileTarget(from, (Entity)entity.m_5448_()).m_82546_(from).m_82541_() : entity.m_20154_();
                dir = dir.m_82490_(10.0).m_82520_(entity.f_19796_.nextGaussian() * 2.3, -Math.abs(entity.f_19796_.nextGaussian()) * 0.6, entity.f_19796_.nextGaussian() * 2.3);
                entity.targetPos = entity.m_20182_().m_82549_(dir);
                ((Spell)((Object)((Object)((Object)ModSpells.FIRE_WALL.get())))).use((LivingEntity)entity);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntitySano>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FIREBALL_3X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FIREBALL_BARRAGE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(EXPLOSION).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_BREATH).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntitySano>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new).duration(e -> e.m_21187_().nextInt(20) + 35), (int)1));
    public final AnimatedAttackGoal<EntitySano> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySano> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private EntityUno other;

    public EntitySano(EntityType<? extends EntitySano> type, Level world) {
        super((EntityType<? extends EntitySanoUno>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.FIRE_WALL.get()))) {
                    this.getAnimationHandler().setAnimation(FIRE_BREATH);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.FIREBALL_BARRAGE.get()))) {
                    this.getAnimationHandler().setAnimation(FIREBALL_BARRAGE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.TRIPLE_FIRE_BALL.get()))) {
                this.getAnimationHandler().setAnimation(FIREBALL_3X);
            }
        }
    }

    public AnimationHandler<EntitySano> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public EntityUno getLinked() {
        List results;
        if (this.other != null && !this.other.m_146910_()) {
            return this.other;
        }
        if (this.getLinkedID() != null && !(results = this.f_19853_.m_142425_(EntityTypeTest.m_156916_(EntityUno.class), this.m_142469_().m_82400_(64.0), e -> this.getLinkedID().equals(e.getLinkedID()))).isEmpty()) {
            this.other = (EntityUno)results.get(0);
        }
        return this.other;
    }
}

