/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;

public class EntitySarcophagus
extends BossMonster {
    public static final AnimatedAction TELEPORT = AnimatedAction.builder((double)2.64, (String)"teleport").marker("teleport_start_1", new double[]{0.2}).marker("teleport_end_1", new double[]{0.44}).marker("teleport_start_2", new double[]{1.2}).marker("teleport_end_2", new double[]{1.44}).marker("teleport_start_3", new double[]{2.2}).marker("teleport_end_3", new double[]{2.44}).marker("teleport", new double[]{0.28, 1.28, 2.28}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.6, (String)"charge").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.48}).build();
    public static final AnimatedAction BEAM = AnimatedAction.builder((double)0.68, (String)"cast").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction BEAM_3X = AnimatedAction.builder((double)2.2, (String)"cast_3x").marker("attack", new double[]{0.48, 1.24, 2.0}).build();
    public static final AnimatedAction FIRE_CIRCLE = AnimatedAction.builder((double)2.32, (String)"circle_cast").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction WIND_CIRCLE = AnimatedAction.copyOf((AnimatedAction)FIRE_CIRCLE, (String)"wind_circle");
    public static final AnimatedAction ICE_CIRCLE = AnimatedAction.copyOf((AnimatedAction)FIRE_CIRCLE, (String)"ice_circle");
    public static final AnimatedAction EARTH_CIRCLE = AnimatedAction.copyOf((AnimatedAction)FIRE_CIRCLE, (String)"earth_circle");
    public static final AnimatedAction LIGHT_2X = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"light_2x");
    public static final AnimatedAction LIGHT_4X = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"light_4x");
    public static final AnimatedAction SHINE = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"shine");
    public static final AnimatedAction PRISM = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"prism");
    public static final AnimatedAction MISSILE = AnimatedAction.builder((double)1.04, (String)"missile").marker("attack", new double[]{0.72}).build();
    public static final AnimatedAction STARFALL = AnimatedAction.builder((double)8.2, (String)"starfall").marker("attack", new double[]{0.8}).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{7.96}).marker("teleport_start", new double[]{0.2}).marker("teleport_end", new double[]{8.0}).build();
    public static final AnimatedAction ANGRY = new AnimatedAction(1.04, "angry");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"interact");
    private static final AnimatedAction[] ANIMATED_ACTIONS = new AnimatedAction[]{TELEPORT, CHARGE, BEAM, BEAM_3X, FIRE_CIRCLE, WIND_CIRCLE, ICE_CIRCLE, EARTH_CIRCLE, LIGHT_2X, LIGHT_4X, SHINE, PRISM, MISSILE, STARFALL, DEFEAT, INTERACT, ANGRY};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntitySarcophagus>> ATTACK_HANDLER = EntitySarcophagus.createAnimationHandler(b -> {
        b.put((Object)TELEPORT, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("teleport_start_1") || anim.isAt("teleport_end_1") || anim.isAt("teleport_start_2") || anim.isAt("teleport_end_2") || anim.isAt("teleport_start_3") || anim.isAt("teleport_end_3")) {
                entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            if (anim.isAt("teleport")) {
                entity.teleportAround(8, 10);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<LivingEntity>();
                }
                if (entity.chargeMotion == null) {
                    entity.setChargeDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(0.3));
                }
                entity.m_20334_(entity.chargeMotion.m_7096_(), entity.m_20184_().m_7098_(), entity.chargeMotion.m_7094_());
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f))) {
                        entity.hitEntity.add((LivingEntity)e);
                    }
                });
                if (entity.f_19797_ % 5 == 0) {
                    entity.m_5496_((SoundEvent)ModSounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.f_19796_.nextFloat() - entity.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                entity.m_20256_(entity.m_20184_().m_82490_(0.6));
            }
        });
        b.put((Object)BEAM, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LIGHT_BEAM.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)BEAM_3X, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LIGHT_BEAM.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)FIRE_CIRCLE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIRE_CIRCLE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)WIND_CIRCLE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WIND_CIRCLE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)ICE_CIRCLE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ICE_CIRCLE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)EARTH_CIRCLE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EARTH_CIRCLE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)LIGHT_2X, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EXPANDING_DOUBLE_LIGHT.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)LIGHT_4X, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EXPANDING_QUAD_LIGHT.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)SHINE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.SHINE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)PRISM, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PRISM_LONG.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)MISSILE, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.MISSILE_8X.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)STARFALL, (anim, entity) -> {
            entity.m_21573_().m_26573_();
            if (anim.isAt("attack_start")) {
                entity.starFallPre = entity.m_20182_();
                if (entity.m_21536_()) {
                    Vec3 pos = Vec3.m_82512_((Vec3i)entity.m_21534_());
                    entity.m_6021_(pos.f_82479_, pos.f_82480_ + 8.0, pos.f_82481_);
                } else if (entity.m_5448_() != null) {
                    entity.m_6021_(entity.m_5448_().m_20185_(), entity.m_5448_().m_20186_() + 8.0, entity.m_5448_().m_20189_());
                } else {
                    entity.m_6021_(entity.m_20185_(), entity.m_20186_() + 8.0, entity.m_20189_());
                }
                entity.starFallPos = entity.m_20182_();
                ((Spell)((Object)((Object)((Object)ModSpells.STARFALL_LONG.get())))).use((LivingEntity)entity);
            }
            if (entity.starFallPos != null) {
                entity.m_146884_(entity.starFallPos);
            }
            if (anim.isAt("attack_end")) {
                entity.m_6021_(entity.starFallPre.m_7096_(), entity.starFallPre.m_7098_(), entity.starFallPre.m_7094_());
                entity.starFallPre = null;
                entity.starFallPos = null;
                entity.teleportAround(6, 12);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntitySarcophagus>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(TELEPORT).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(CHARGE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(BEAM).withCondition((goal, target, previous) -> !((EntitySarcophagus)goal.attacker).isEnraged() && ((EntitySarcophagus)goal.attacker).allowAnimation(previous, BEAM)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(BEAM_3X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WIND_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(ICE_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(EARTH_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(LIGHT_2X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(LIGHT_4X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(SHINE).withCondition((goal, target, previous) -> !((EntitySarcophagus)goal.attacker).isEnraged() && ((EntitySarcophagus)goal.attacker).allowAnimation(previous, SHINE)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)7), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(PRISM).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)7), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(MISSILE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.enragedBossAttack(STARFALL).withCondition((goal, target, previous) -> ((EntitySarcophagus)goal.attacker).isEnraged() && ((EntitySarcophagus)goal.attacker).starfallCooldown <= 0).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntitySarcophagus>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new DoNothingRunner(true)), (int)1));
    public final AnimatedAttackGoal<EntitySarcophagus> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySarcophagus> animationHandler = new AnimationHandler((Entity)this, ANIMATED_ACTIONS).withChangeListener(anim -> {
        this.hitEntity = null;
        if (anim != null) {
            this.teleported = TELEPORT.is(new AnimatedAction[]{anim});
            if (!TELEPORT.is(new AnimatedAction[]{anim})) {
                this.previousAttack = anim.getID();
            }
            if (CHARGE.is(new AnimatedAction[]{anim})) {
                this.chargeMotion = null;
                this.prevStepHeight = this.f_19793_;
                this.f_19793_ = 1.0f + this.f_19793_;
            }
            if (STARFALL.is(new AnimatedAction[]{anim})) {
                this.gravityPre = this.m_20068_();
                this.starfallCooldown = 240 + this.m_21187_().nextInt(600);
                this.m_20242_(true);
            }
        } else {
            if (this.prevStepHeight != -1.0f) {
                this.f_19793_ = this.prevStepHeight;
                this.prevStepHeight = -1.0f;
            }
            if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{STARFALL})) {
                this.m_20242_(this.gravityPre);
            }
        }
        return false;
    });
    private Vec3 chargeMotion;
    private Vec3 starFallPre;
    private Vec3 starFallPos;
    protected List<LivingEntity> hitEntity;
    private boolean teleported;
    private boolean gravityPre;
    private String previousAttack = "";
    private int starfallCooldown;
    private float prevStepHeight = -1.0f;

    public EntitySarcophagus(EntityType<? extends EntitySarcophagus> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
        this.f_19793_ = 1.0f;
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.SARCOPHAGUS_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.26);
        super.applyAttributes();
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{DEFEAT, ANGRY}) && !this.isTeleporting()) && super.m_6469_(source, amount);
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public boolean m_6000_(double x, double y, double z) {
        if (this.isTeleporting()) {
            return false;
        }
        return super.m_6000_(x, y, z);
    }

    private boolean isTeleporting() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        if (TELEPORT.is(new AnimatedAction[]{anim})) {
            if (anim.isPast("teleport_start_1") && !anim.isPast("teleport_end_1")) {
                return true;
            }
            if (anim.isPast("teleport_start_2") && !anim.isPast("teleport_end_2")) {
                return true;
            }
            return anim.isPast("teleport_start_3") && !anim.isPast("teleport_end_3");
        }
        if (STARFALL.is(new AnimatedAction[]{anim})) {
            return anim.isPast("teleport_start") && !anim.isPast("teleport_end");
        }
        return false;
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT, TELEPORT, STARFALL})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        if (TELEPORT.is(new AnimatedAction[]{anim})) {
            return 7 + this.m_21187_().nextInt(6);
        }
        return super.animationCooldown(anim);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{CHARGE})) {
            double width = this.m_20205_();
            double speed = Math.max(width, this.m_20184_().m_82553_() - width);
            float rotY = -Mth.m_14177_((float)((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(grow + 0.4, 0.1, grow + 0.4).m_82363_(0.0, 0.0, speed), rotY, 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler;
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.m_21573_().m_26573_();
            this.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
        }
        if ((handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID())) != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.FIRE_CIRCLE.get()))) {
                    this.getAnimationHandler().setAnimation(FIRE_CIRCLE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.MISSILE_8X.get()))) {
                    this.getAnimationHandler().setAnimation(MISSILE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.LIGHT_BEAM.get()))) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.starfallCooldown;
        }
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            if (this.getAnimationHandler().getAnimation().isPast("attack_start")) {
                return this.chargeMotion;
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.84375, -0.5);
    }

    public AnimationHandler<EntitySarcophagus> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (!this.teleported) {
            return TELEPORT.is(new AnimatedAction[]{other});
        }
        return !TELEPORT.is(new AnimatedAction[]{other}) && !this.previousAttack.equals(other.getID());
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    private void teleportAround(int range, int yRange) {
        Vec3 pos = this.m_21536_() ? Vec3.m_82512_((Vec3i)this.m_21534_()) : (this.m_5448_() != null ? this.m_5448_().m_20182_() : this.m_20182_());
        for (int i = 0; i < 10; ++i) {
            double x = pos.m_7096_() + (this.m_21187_().nextDouble() * 2.0 - 1.0) * (double)range;
            double y = pos.m_7098_() + 4.0;
            double z = pos.m_7094_() + (this.m_21187_().nextDouble() * 2.0 - 1.0) * (double)range;
            if (this.m_21536_() && this.m_21534_().m_203198_(x, y, z) > (double)(this.m_21535_() * this.m_21535_()) || !this.teleport(x, y, z, yRange)) continue;
            return;
        }
    }

    private boolean teleport(double x, double y, double z, int yRange) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y - 1.0, z);
        ChunkAccess chunk = this.f_19853_.m_46865_((BlockPos)pos);
        while (yRange > 0 && pos.m_123342_() > this.f_19853_.m_141937_() && !chunk.m_8055_((BlockPos)pos).m_60767_().m_76334_()) {
            pos.m_122173_(Direction.DOWN);
            --yRange;
            y -= 1.0;
        }
        BlockState blockState = chunk.m_8055_((BlockPos)pos);
        if (!blockState.m_60767_().m_76334_()) {
            return false;
        }
        Vec3 current = this.m_20182_();
        this.m_6021_(x, y, z);
        if (!this.f_19853_.m_45786_((Entity)this) || this.f_19853_.m_46855_(this.m_142469_())) {
            this.m_6021_(current.m_7096_(), current.m_7098_(), current.m_7094_());
            return false;
        }
        return true;
    }

    protected void setChargeDirection(Vec3 moveDirection) {
        this.chargeMotion = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.chargeMotion = motion;
        });
    }
}

